/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.boot.commands.support.ParameterCompleter;
import io.fabric8.boot.commands.support.ProfileCompleter;
import io.fabric8.boot.commands.support.VersionCompleter;
import io.fabric8.commands.ProfileCreateAction;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.console.Completer;

@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"profile-create"})})
public class ProfileCreate
extends AbstractCommandComponent {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "profile-create";
    public static final String DESCRIPTION = "Create a new profile with the specified name and version";
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=VersionCompleter.class, bind="bindVersionCompleter", unbind="unbindVersionCompleter")
    private VersionCompleter versionCompleter;
    @Reference(referenceInterface=ProfileCompleter.class, bind="bindParentsProfileCompleter", unbind="unbindParentsProfileCompleter")
    private VersionCompleter parentsProfileCompleter;

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public Action createNewAction() {
        this.assertValid();
        return new ProfileCreateAction((FabricService)this.fabricService.get());
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindVersionCompleter(VersionCompleter completer) {
        this.bindOptionalCompleter("--version", (Completer)completer);
    }

    void unbindVersionCompleter(VersionCompleter completer) {
        this.unbindOptionalCompleter((ParameterCompleter)completer);
    }

    void bindParentsProfileCompleter(ProfileCompleter completer) {
        this.bindOptionalCompleter("--parents", (Completer)completer);
    }

    void unbindParentsProfileCompleter(ProfileCompleter completer) {
        this.unbindOptionalCompleter((ParameterCompleter)completer);
    }
}

