/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.common.util.Strings;
import io.fabric8.utils.FabricVersionUtils;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="info", scope="fabric", description="Displays information about the fabric")
public class FabricInfoAction
extends AbstractAction {
    static final String FORMAT = "%-30s %s";
    private final FabricService fabricService;
    private final RuntimeProperties runtimeProperties;

    FabricInfoAction(FabricService fabricService, RuntimeProperties runtimeProperties) {
        this.fabricService = fabricService;
        this.runtimeProperties = runtimeProperties;
    }

    protected Object doExecute() throws Exception {
        System.out.println(String.format(FORMAT, "Fabric Release:", Strings.emptyIfNull((String)FabricVersionUtils.getReleaseVersion())));
        System.out.println(String.format(FORMAT, "Web Console:", Strings.emptyIfNull((String)this.fabricService.getWebConsoleUrl())));
        System.out.println(String.format(FORMAT, "Rest API:", Strings.emptyIfNull((String)this.fabricService.getRestAPI())));
        System.out.println(String.format(FORMAT, "Git URL:", Strings.emptyIfNull((String)this.fabricService.getGitUrl())));
        System.out.println(String.format(FORMAT, "ZooKeeper URI:", Strings.emptyIfNull((String)this.fabricService.getZookeeperUrl())));
        System.out.println(String.format(FORMAT, "Maven Download URI:", this.fabricService.getMavenRepoURI()));
        System.out.println(String.format(FORMAT, "Maven Upload URI:", this.fabricService.getMavenRepoUploadURI()));
        return null;
    }
}

