/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.boot.commands.support.ContainerCompleter;
import io.fabric8.boot.commands.support.VersionCompleter;
import io.fabric8.commands.ContainerRollbackAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.NullCompleter;

@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"container-rollback"})})
public class ContainerRollback
extends AbstractCommandComponent {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "container-rollback";
    public static final String DESCRIPTION = "Roll back the specified containers to an older version";
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=ContainerCompleter.class, bind="bindContainerCompleter", unbind="unbindContainerCompleter")
    private ContainerCompleter containerCompleter;
    @Reference(referenceInterface=VersionCompleter.class, bind="bindVersionCompleter", unbind="unbindVersionCompleter", cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private VersionCompleter versionCompleter;
    private final List<Completer> completers = new ArrayList<Completer>();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public Action createNewAction() {
        this.assertValid();
        return new ContainerRollbackAction((FabricService)this.fabricService.get());
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindContainerCompleter(ContainerCompleter completer) {
        List<Completer> list = this.completers;
        synchronized (list) {
            this.completers.add((Completer)completer);
        }
    }

    void unbindContainerCompleter(ContainerCompleter completer) {
        this.completers.remove(completer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindVersionCompleter(VersionCompleter completer) {
        List<Completer> list = this.completers;
        synchronized (list) {
            this.completers.add(0, (Completer)completer);
        }
    }

    void unbindVersionCompleter(VersionCompleter completer) {
        this.completers.remove(completer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Completer> getCompleters() {
        List<Completer> list = this.completers;
        synchronized (list) {
            if (this.completers.isEmpty()) {
                return Arrays.asList(new NullCompleter());
            }
            return Collections.unmodifiableList(this.completers);
        }
    }
}

