/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.api.Version;
import io.fabric8.commands.support.CommandUtils;
import java.io.PrintStream;
import java.util.List;
import java.util.Locale;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="container-list", scope="fabric", description="List the containers in the current fabric", detailedDescription="classpath:containerList.txt")
public class ContainerListAction
extends AbstractAction {
    static final String FORMAT = "%-30s %-9s %-10s %-11s %-60s %s";
    static final String VERBOSE_FORMAT = "%-30s %-9s %-10s %-11s %-60s %-13s %-11s %s";
    static final String[] HEADERS = new String[]{"[id]", "[version]", "[type]", "[connected]", "[profiles]", "[provision status]"};
    static final String[] VERBOSE_HEADERS = new String[]{"[id]", "[version]", "[type]", "[connected]", "[profiles]", "[blueprint]", "[spring]", "[provision status]"};
    @Option(name="--version", description="Optional version to use as filter")
    private String version;
    @Option(name="-v", aliases={"--verbose"}, description="Flag for verbose output", multiValued=false, required=false)
    private boolean verbose;
    @Argument(index=0, name="filter", description="Filter by container ID or by profile name. When a profile name is specified, only the containers with that profile are listed.", required=false, multiValued=false)
    private String filter = null;
    private final FabricService fabricService;

    ContainerListAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        Container[] containers = this.fabricService.getContainers();
        containers = CommandUtils.filterContainers(containers, this.filter);
        containers = CommandUtils.sortContainers(containers);
        Version ver = null;
        if (this.version != null) {
            ver = this.fabricService.getVersion(this.version);
        }
        if (this.verbose) {
            this.printContainersVerbose(containers, ver, System.out);
        } else {
            this.printContainers(containers, ver, System.out);
        }
        return null;
    }

    private void printContainers(Container[] containers, Version version, PrintStream out) {
        out.println(String.format(FORMAT, HEADERS));
        for (Container container : containers) {
            if (!CommandUtils.matchVersion(container, version)) continue;
            String indent = "";
            Container c = container;
            while (!c.isRoot()) {
                indent = indent + "  ";
                c = c.getParent();
            }
            String marker = "";
            if (container.getId().equals(this.fabricService.getCurrentContainer().getId())) {
                marker = "*";
            }
            List assignedProfiles = this.fabricService.getDataStore().getContainerProfiles(container.getId());
            String firstLine = String.format(FORMAT, indent + container.getId() + marker, container.getVersion().getId(), container.getType(), container.isAlive(), assignedProfiles.get(0), CommandUtils.status(container));
            out.println(firstLine);
            for (int i = 1; i < assignedProfiles.size(); ++i) {
                String nextLine = String.format(FORMAT, "", "", "", "", assignedProfiles.get(i), "");
                out.println(nextLine);
            }
        }
    }

    private void printContainersVerbose(Container[] containers, Version version, PrintStream out) {
        String header = String.format(VERBOSE_FORMAT, VERBOSE_HEADERS);
        out.println(header);
        for (Container container : containers) {
            if (!CommandUtils.matchVersion(container, version)) continue;
            String indent = "";
            Container c = container;
            while (!c.isRoot()) {
                indent = indent + "  ";
                c = c.getParent();
            }
            String marker = "";
            if (container.getId().equals(this.fabricService.getCurrentContainer().getId())) {
                marker = "*";
            }
            String blueprintStatus = this.fabricService.getDataStore().getContainerAttribute(container.getId(), DataStore.ContainerAttribute.BlueprintStatus, "", false, false);
            String springStatus = this.fabricService.getDataStore().getContainerAttribute(container.getId(), DataStore.ContainerAttribute.SpringStatus, "", false, false);
            blueprintStatus = blueprintStatus.toLowerCase(Locale.ENGLISH);
            springStatus = springStatus.toLowerCase(Locale.ENGLISH);
            List assignedProfiles = this.fabricService.getDataStore().getContainerProfiles(container.getId());
            String firstLine = String.format(VERBOSE_FORMAT, indent + container.getId() + marker, container.getVersion().getId(), container.getType(), container.isAlive(), assignedProfiles.get(0), blueprintStatus, springStatus, CommandUtils.status(container));
            out.println(firstLine);
            for (int i = 1; i < assignedProfiles.size(); ++i) {
                String nextLine = String.format(VERBOSE_FORMAT, "", "", "", "", assignedProfiles.get(i), "", "", "");
                out.println(nextLine);
            }
        }
    }
}

