/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.boot.commands.support.ParameterCompleter;
import io.fabric8.boot.commands.support.ProfileCompleter;
import io.fabric8.commands.RequireProfileSetAction;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.console.Completer;

@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"require-profile-set"})})
public final class RequireProfileSet
extends AbstractCommandComponent {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "require-profile-set";
    public static final String DESCRIPTION = "Sets the requirements of a profile in terms of its minimum and maximum required instances";
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=ProfileCompleter.class, bind="bindProfileCompleter", unbind="unbindProfileCompleter")
    private ProfileCompleter profileCompleter;
    @Reference(referenceInterface=ProfileCompleter.class, bind="bindDependsOnProfileCompleter", unbind="unbindDependsOnProfileCompleter")
    private ProfileCompleter dependsOnProfileCompleter;

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public Action createNewAction() {
        this.assertValid();
        return new RequireProfileSetAction((FabricService)this.fabricService.get());
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindProfileCompleter(ProfileCompleter completer) {
        this.bindCompleter((Completer)completer);
    }

    void unbindProfileCompleter(ProfileCompleter completer) {
        this.unbindCompleter((Completer)completer);
    }

    void bindDependsOnProfileCompleter(ProfileCompleter completer) {
        this.bindOptionalCompleter("--dependsOn", (Completer)completer);
    }

    void unbindDependsOnProfileCompleter(ProfileCompleter completer) {
        this.unbindOptionalCompleter((ParameterCompleter)completer);
    }
}

