/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.Version;
import io.fabric8.utils.FabricValidations;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CompleterValues;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="profile-rename", scope="fabric", description="Rename the specified version of the source profile (where the version defaults to the current default version)")
public class ProfileRenameAction
extends AbstractAction {
    @Option(name="--version", description="The profile version to rename. Defaults to the current default version.")
    private String version;
    @Option(name="-f", aliases={"--force"}, description="Flag to allow replacing the target profile (if exists).")
    private boolean force;
    @Argument(index=0, required=true, name="profile name", description="Name of the profile.")
    @CompleterValues(index=0)
    private String profileName;
    @Argument(index=1, required=true, name="new profile name", description="New name of the profile.")
    @CompleterValues(index=1)
    private String newName;
    private final FabricService fabricService;

    ProfileRenameAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    protected Object doExecute() throws Exception {
        Version ver;
        FabricValidations.validateProfileName(this.profileName);
        FabricValidations.validateProfileName(this.newName);
        Version version = ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
        if (!ver.hasProfile(this.profileName)) {
            System.out.println("Profile " + this.profileName + " not found.");
            return null;
        }
        if (ver.hasProfile(this.newName) && !this.force) {
            System.out.println("New name " + this.newName + " already exists. Use --force if you want to overwrite.");
            return null;
        }
        ver.renameProfile(this.profileName, this.newName, this.force);
        return null;
    }
}

