/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.common.util.Strings;
import io.fabric8.utils.FabricValidations;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="container-info", scope="fabric", description="Displays information about the containers")
public class ContainerInfoAction
extends AbstractAction {
    static final String FORMAT = "%-30s %s";
    @Argument(index=0, name="container", description="The name of the container container.", required=false, multiValued=false)
    private String containerName;
    private final FabricService fabricService;
    private final RuntimeProperties runtimeProperties;

    ContainerInfoAction(FabricService fabricService, RuntimeProperties runtimeProperties) {
        this.fabricService = fabricService;
        this.runtimeProperties = runtimeProperties;
    }

    protected Object doExecute() throws Exception {
        this.containerName = Strings.isNotBlank((String)this.containerName) ? this.containerName : this.runtimeProperties.getProperty("karaf.name");
        FabricValidations.validateContainerName(this.containerName);
        if (!this.containerExists(this.containerName)) {
            System.out.println("Container " + this.containerName + " does not exists!");
            return null;
        }
        Container container = this.fabricService.getContainer(this.containerName);
        System.out.println(String.format(FORMAT, "Name:", container.getId()));
        System.out.println(String.format(FORMAT, "Version:", container.getVersion()));
        System.out.println(String.format(FORMAT, "Alive:", container.isAlive()));
        System.out.println(String.format(FORMAT, "Resolver:", container.getResolver()));
        System.out.println(String.format(FORMAT, "Network Address:", container.getIp()));
        System.out.println(String.format(FORMAT, "SSH Url:", container.getSshUrl()));
        System.out.println(String.format(FORMAT, "JMX Url:", container.getJmxUrl()));
        System.out.println(String.format(FORMAT, "Process ID:", container.getProcessId()));
        StringBuilder sb = new StringBuilder();
        Profile[] profiles = container.getProfiles();
        for (int i = 0; i < profiles.length; ++i) {
            if (i != 0) {
                sb.append(" ");
            }
            sb.append(profiles[i].getId());
        }
        System.out.println(String.format(FORMAT, "Profiles:", sb.toString()));
        System.out.println(String.format(FORMAT, "Provision Status:", container.getProvisionStatus()));
        String blueprintStatus = this.fabricService.getDataStore().getContainerAttribute(this.containerName, DataStore.ContainerAttribute.BlueprintStatus, "", false, false);
        String springStatus = this.fabricService.getDataStore().getContainerAttribute(this.containerName, DataStore.ContainerAttribute.SpringStatus, "", false, false);
        if (!blueprintStatus.isEmpty()) {
            System.out.println(String.format(FORMAT, "Blueprint Status:", blueprintStatus.toLowerCase()));
        }
        if (!springStatus.isEmpty()) {
            System.out.println(String.format(FORMAT, "Spring Status:", springStatus.toLowerCase()));
        }
        if (container.getProvisionException() != null) {
            System.out.println(String.format(FORMAT, "Provision Error:", container.getProvisionException()));
        }
        return null;
    }

    private boolean containerExists(String containerName) {
        Container[] containers;
        for (Container c : containers = this.fabricService.getContainers()) {
            if (!containerName.equals(c.getId())) continue;
            return true;
        }
        return false;
    }
}

