/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Version;
import io.fabric8.commands.support.CommandUtils;
import java.io.PrintStream;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="version-list", scope="fabric", description="List the existing versions")
public class VersionListAction
extends AbstractAction {
    private final FabricService fabricService;

    VersionListAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    protected Object doExecute() throws Exception {
        Container[] containers = this.getFabricService().getContainers();
        Version[] versions = this.getFabricService().getVersions();
        this.printVersions(containers, versions, this.getFabricService().getDefaultVersion(), System.out);
        return null;
    }

    protected void printVersions(Container[] containers, Version[] versions, Version defaultVersion, PrintStream out) {
        out.println(String.format("%-15s %-9s %-14s", "[version]", "[default]", "[# containers]"));
        for (Version version : versions) {
            boolean isDefault = defaultVersion.getId().equals(version.getId());
            int active = CommandUtils.countContainersByVersion(containers, version);
            out.println(String.format("%-15s %-9s %-14s", version.getId(), isDefault ? "true" : "false", active));
        }
    }
}

