/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.utils.FabricValidations;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="container-remove-profile", scope="fabric", description="Removes a profile form container's list of profiles")
public class ContainerRemoveProfileAction
extends AbstractAction {
    @Argument(index=0, name="container", description="The container name", required=true, multiValued=false)
    private String container;
    @Argument(index=1, name="profiles", description="The profiles to remove from the container", required=true, multiValued=true)
    private List<String> profiles;
    private final FabricService fabricService;

    ContainerRemoveProfileAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        FabricValidations.validateContainerName(this.container);
        Container cont = FabricCommand.getContainer((FabricService)this.fabricService, (String)this.container);
        Profile[] profs = FabricCommand.getProfiles((FabricService)this.fabricService, (Version)cont.getVersion(), this.profiles);
        cont.removeProfiles(profs);
        return null;
    }
}

