/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.boot.commands.support.FabricCommand;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="profile-change-parents", scope="fabric", description="Replace the profile's parents with the specified list of parents (where the parents are specified as a space-separated list)")
public class ProfileChangeParents
extends FabricCommand {
    @Option(name="--version", description="The profile version. Defaults to the current default version.")
    private String version;
    @Argument(index=0, required=true, name="profile", description="Name of the profile.")
    private String name;
    @Argument(index=1, name="parents", description="The list of new parent profiles.", required=true, multiValued=true)
    private List<String> parents;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        Version ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
        Profile prof = FabricCommand.getProfile((Version)ver, (String)this.name);
        Profile[] profs = FabricCommand.getProfiles((FabricService)this.fabricService, (Version)ver, this.parents);
        prof.setParents(profs);
        return null;
    }
}

