/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricException;
import io.fabric8.boot.commands.support.FabricCommand;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="wait-for-provisioning", scope="fabric", description="Waits for containers to be provisioned")
public class WaitForProvisioning
extends FabricCommand {
    @Option(name="-v", aliases={"--verbose"}, description="Flag for verbose output", multiValued=false, required=false)
    private boolean verbose;
    @Option(name="--provision-timeout", multiValued=false, description="How long to wait (milliseconds) for the containers to provision")
    private long provisionTimeout = 120000L;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        return this.waitForSuccessfulDeploymentOf();
    }

    private String waitForSuccessfulDeploymentOf() throws InterruptedException {
        long startedAt = System.currentTimeMillis();
        while (!Thread.interrupted() && startedAt + this.provisionTimeout > System.currentTimeMillis()) {
            try {
                Container[] fabric = this.fabricService.getContainers();
                if (this.isFabricProvisioned(fabric)) {
                    return "SUCCESS";
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                throw FabricException.launderThrowable((Throwable)t);
            }
        }
        return "ERROR";
    }

    private boolean isFabricProvisioned(Container[] fabric) throws InterruptedException {
        if (fabric == null) {
            return false;
        }
        for (Container container : fabric) {
            if (container != null && container.isAlive() && "success".equals(container.getProvisionStatus())) continue;
            if (this.verbose) {
                System.out.println(String.format("Waiting: Container %s is %s", container.getId(), container.getProvisionStatus()));
            }
            if (container.getProvisionStatus() != null && container.getProvisionStatus().startsWith("error")) {
                throw new FabricException("Error provisioning container " + container.getId() + " : " + container.getProvisionStatus());
            }
            return false;
        }
        return true;
    }
}

