/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricAuthenticationException;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.jmx.BrokerKind;
import io.fabric8.api.jmx.MQBrokerConfigDTO;
import io.fabric8.api.jmx.MQManager;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.utils.Strings;
import io.fabric8.utils.shell.ShellUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CompleterValues;
import org.apache.felix.gogo.commands.Option;

@Command(name="mq-create", scope="fabric", description="Create a new broker")
public class MQCreate
extends FabricCommand {
    @Argument(index=0, required=true, description="Broker name")
    protected String name = null;
    @Option(name="--parent-profile", description="The parent profile to extend")
    protected String parentProfile;
    @Option(name="--profile", description="The profile name to create/update if defining N+1 broker groups (otherwise this is defaulted to the broker name). Defaults to 'mq-broker-$GROUP.$NAME'")
    protected String profile;
    @Option(name="--client-profile", description="The profile name for clients to use to connect to the broker group. Defaults to 'mq-client-$GROUP'")
    protected String clientProfile;
    @Option(name="--client-parent-profile", description="The parent profile used for the client-profile for clients connecting to the broker group. Defaults to 'default'")
    protected String clientParentProfile;
    @Option(name="--property", aliases={"-D"}, description="Additional properties to define in the profile", multiValued=true)
    List<String> properties;
    @Option(name="--config", description="Configuration to use")
    protected String config;
    @Option(name="--data", description="Data directory for the broker")
    protected String data;
    @Option(name="--ports", multiValued=true, description="Port number for the transport connectors")
    protected String[] ports;
    @Option(name="--group", description="Broker group")
    protected String group;
    @Option(name="--networks", multiValued=true, description="Broker networks")
    protected String[] networks;
    @Option(name="--networks-username", description="Broker networks UserName")
    protected String networksUserName;
    @Option(name="--networks-password", description="Broker networks Password")
    protected String networksPassword;
    @Option(name="--version", description="The version id in the registry")
    protected String version = "1.0";
    @Option(name="--create-container", multiValued=false, required=false, description="Comma separated list of child containers to create with mq profile")
    protected String create;
    @Option(name="--assign-container", multiValued=false, required=false, description="Assign this mq profile to the following containers")
    protected String assign;
    @Option(name="--jmx-user", multiValued=false, required=false, description="The jmx user name of the parent container.")
    protected String username;
    @Option(name="--jmx-password", multiValued=false, required=false, description="The jmx password of the parent container.")
    protected String password;
    @Option(name="--jvm-opts", multiValued=false, required=false, description="Options to pass to the container's JVM.")
    protected String jvmOpts;
    @Option(name="--minimumInstances", multiValued=false, required=false, description="Minimum number of containers required of this broker's profile.")
    protected Integer minimumInstances;
    @Option(name="--replicas", multiValued=false, required=false, description="Number of replicas required for replicated brokers (which typically use a parent-profile of mq-replicated profile).")
    protected Integer replicas;
    @Option(name="--kind", multiValued=false, required=false, description="The kind of broker to create")
    @CompleterValues
    protected BrokerKind kind;

    protected Object doExecute() throws Exception {
        MQBrokerConfigDTO dto = this.createDTO();
        Profile profile = MQManager.createOrUpdateProfile((MQBrokerConfigDTO)dto, (FabricService)this.fabricService);
        String profileId = profile.getId();
        System.out.println("MQ profile " + profileId + " ready");
        if (this.assign != null) {
            String[] assignContainers = this.assign.split(",");
            MQManager.assignProfileToContainers((FabricService)this.fabricService, (Profile)profile, (String[])assignContainers);
        }
        if (this.create != null) {
            String[] createContainers = this.create.split(",");
            List builderList = MQManager.createContainerBuilders((MQBrokerConfigDTO)dto, (FabricService)this.fabricService, (String)"child", (String)profileId, (String)dto.version(), (String[])createContainers);
            for (CreateContainerBasicOptions.Builder builder : builderList) {
                CreateContainerMetadata[] metadatas = null;
                try {
                    if (builder instanceof CreateChildContainerOptions.Builder) {
                        CreateChildContainerOptions.Builder childBuilder = (CreateChildContainerOptions.Builder)builder;
                        builder = childBuilder.jmxUser(this.username).jmxPassword(this.password);
                    }
                    metadatas = this.fabricService.createContainers((CreateContainerOptions)builder.build());
                    ShellUtils.storeFabricCredentials(this.session, this.username, this.password);
                }
                catch (FabricAuthenticationException fae) {
                    if (!(builder instanceof CreateChildContainerOptions.Builder)) continue;
                    CreateChildContainerOptions.Builder childBuilder = (CreateChildContainerOptions.Builder)builder;
                    this.promptForJmxCredentialsIfNeeded();
                    metadatas = this.fabricService.createContainers((CreateContainerOptions)childBuilder.jmxUser(this.username).jmxPassword(this.password).build());
                    ShellUtils.storeFabricCredentials(this.session, this.username, this.password);
                }
            }
        }
        return null;
    }

    private MQBrokerConfigDTO createDTO() {
        if (Strings.isNullOrBlank(this.username)) {
            this.username = ShellUtils.retrieveFabricUser(this.session);
        }
        if (Strings.isNullOrBlank(this.password)) {
            this.password = ShellUtils.retrieveFabricUserPassword(this.session);
        }
        MQBrokerConfigDTO dto = new MQBrokerConfigDTO();
        dto.setConfigUrl(this.config);
        dto.setData(this.data);
        if (this.ports != null && this.ports.length > 0) {
            for (String port : this.ports) {
                this.addConfig(port, dto.getPorts());
            }
        }
        dto.setGroup(this.group);
        dto.setJvmOpts(this.jvmOpts);
        dto.setBrokerName(this.name);
        dto.setProfile(this.profile);
        dto.setClientProfile(this.clientProfile);
        dto.setClientParentProfile(this.clientParentProfile);
        dto.setNetworks(this.networks);
        dto.setNetworksPassword(this.networksPassword);
        dto.setNetworksUserName(this.networksUserName);
        dto.setParentProfile(this.parentProfile);
        dto.setProperties(this.properties);
        dto.setVersion(this.version);
        dto.setMinimumInstances(this.minimumInstances);
        dto.setReplicas(this.replicas);
        if (this.kind != null) {
            dto.setKind(this.kind);
        }
        return dto;
    }

    private void promptForJmxCredentialsIfNeeded() throws IOException {
        if (this.username == null) {
            this.log.debug("Prompting user for jmx login");
            this.username = ShellUtils.readLine(this.session, "Jmx Login for " + this.fabricService.getCurrentContainerName() + ": ", false);
        }
        if (this.password == null) {
            this.password = ShellUtils.readLine(this.session, "Jmx Password for " + this.fabricService.getCurrentContainerName() + ": ", true);
        }
    }

    private void addConfig(String config, Map<String, String> map) {
        String key = null;
        String value = null;
        if (config.contains("=")) {
            key = config.substring(0, config.indexOf("="));
            value = config.substring(config.indexOf("=") + 1);
        }
        if (key != null && value != null) {
            map.put(key, value);
        }
    }
}

