/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.request;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.jolokia.client.request.J4pListResponse;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pTargetConfig;
import org.jolokia.client.request.J4pType;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J4pListRequest
extends J4pRequest {
    private List<String> pathElements;

    protected J4pListRequest() {
        this(null, (String)null);
    }

    protected J4pListRequest(J4pTargetConfig pTargetConfig) {
        this(pTargetConfig, (String)null);
    }

    public J4pListRequest(String pPath) {
        this(null, pPath);
    }

    public J4pListRequest(J4pTargetConfig pConfig, String pPath) {
        super(J4pType.LIST, pConfig);
        this.pathElements = this.splitPath(pPath);
    }

    public J4pListRequest(List<String> pPathElements) {
        this(null, pPathElements);
    }

    public J4pListRequest(J4pTargetConfig pConfig, List<String> pPathElements) {
        super(J4pType.LIST, pConfig);
        this.pathElements = pPathElements;
    }

    public J4pListRequest(ObjectName pObjectName) {
        this(null, pObjectName);
    }

    public J4pListRequest(J4pTargetConfig pConfig, ObjectName pObjectName) {
        super(J4pType.LIST, pConfig);
        this.pathElements = new ArrayList<String>();
        this.pathElements.add(pObjectName.getDomain());
        this.pathElements.add(pObjectName.getCanonicalKeyPropertyListString());
    }

    J4pListResponse createResponse(JSONObject pResponse) {
        return new J4pListResponse(this, pResponse);
    }

    @Override
    List<String> getRequestParts() {
        return this.pathElements;
    }

    @Override
    JSONObject toJson() {
        JSONObject ret = super.toJson();
        if (this.pathElements != null) {
            StringBuilder path = new StringBuilder();
            for (int i = 0; i < this.pathElements.size(); ++i) {
                path.append(J4pListRequest.escape(this.pathElements.get(i)));
                if (i >= this.pathElements.size() - 1) continue;
                path.append("/");
            }
            ret.put("path", path.toString());
        }
        return ret;
    }
}

