/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.request;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.client.request.AbtractJ4pMBeanRequest;
import org.jolokia.client.request.J4pExecResponse;
import org.jolokia.client.request.J4pTargetConfig;
import org.jolokia.client.request.J4pType;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J4pExecRequest
extends AbtractJ4pMBeanRequest {
    private String operation;
    private List<Object> arguments;

    public J4pExecRequest(ObjectName pMBeanName, String pOperation, Object ... pArgs) {
        this(null, pMBeanName, pOperation, pArgs);
    }

    public J4pExecRequest(J4pTargetConfig pTargetConfig, ObjectName pMBeanName, String pOperation, Object ... pArgs) {
        super(J4pType.EXEC, pMBeanName, pTargetConfig);
        this.operation = pOperation;
        if (pArgs == null) {
            this.arguments = new ArrayList<Object>();
            this.arguments.add(null);
        } else {
            this.arguments = Arrays.asList(pArgs);
        }
    }

    public J4pExecRequest(String pMBeanName, String pOperation, Object ... pArgs) throws MalformedObjectNameException {
        this(null, pMBeanName, pOperation, pArgs);
    }

    public J4pExecRequest(J4pTargetConfig pTargetConfig, String pMBeanName, String pOperation, Object ... pArgs) throws MalformedObjectNameException {
        this(pTargetConfig, new ObjectName(pMBeanName), pOperation, pArgs);
    }

    public String getOperation() {
        return this.operation;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    J4pExecResponse createResponse(JSONObject pResponse) {
        return new J4pExecResponse(this, pResponse);
    }

    @Override
    List<String> getRequestParts() {
        List<String> ret = super.getRequestParts();
        ret.add(this.operation);
        if (this.arguments.size() > 0) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                ret.add(this.serializeArgumentToRequestPart(this.arguments.get(i)));
            }
        }
        return ret;
    }

    @Override
    JSONObject toJson() {
        JSONObject ret = super.toJson();
        ret.put("operation", this.operation);
        if (this.arguments.size() > 0) {
            JSONArray args = new JSONArray();
            for (Object arg : this.arguments) {
                args.add(this.serializeArgumentToJson(arg));
            }
            ret.put("arguments", args);
        }
        return ret;
    }
}

