/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client;

import java.nio.charset.Charset;
import javax.net.ssl.SSLContext;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.io.DefaultHttpRequestWriterFactory;
import org.apache.http.impl.io.DefaultHttpResponseParserFactory;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.VersionInfo;
import org.jolokia.client.BasicAuthenticator;
import org.jolokia.client.J4pAuthenticator;
import org.jolokia.client.J4pClient;
import org.jolokia.client.request.J4pTargetConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J4pClientBuilder {
    private int connectionTimeout;
    private int socketTimeout;
    private int maxTotalConnections;
    private int maxConnectionPoolTimeout;
    private Charset contentCharset;
    private boolean expectContinue;
    private boolean tcpNoDelay;
    private int socketBufferSize;
    private boolean pooledConnections;
    private String url;
    private String user;
    private String password;
    private String targetUrl;
    private String targetUser;
    private String targetPassword;
    private CookieStore cookieStore;
    private J4pAuthenticator authenticator;

    public J4pClientBuilder() {
        this.connectionTimeout(20000);
        this.socketTimeout(-1);
        this.maxTotalConnections(20);
        this.maxConnectionPoolTimeout(500);
        this.contentCharset(HTTP.DEF_CONTENT_CHARSET.name());
        this.expectContinue(true);
        this.tcpNoDelay(true);
        this.socketBufferSize(8192);
        this.pooledConnections();
        this.user(null);
        this.password(null);
        this.cookieStore(new BasicCookieStore());
        this.authenticator(new BasicAuthenticator());
    }

    public final J4pClientBuilder url(String pUrl) {
        this.url = pUrl;
        return this;
    }

    public final J4pClientBuilder user(String pUser) {
        this.user = pUser;
        return this;
    }

    public final J4pClientBuilder password(String pPassword) {
        this.password = pPassword;
        return this;
    }

    public final J4pClientBuilder target(String pUrl) {
        this.targetUrl = pUrl;
        return this;
    }

    public final J4pClientBuilder targetUser(String pUser) {
        this.targetUser = pUser;
        return this;
    }

    public final J4pClientBuilder targetPassword(String pPassword) {
        this.targetPassword = pPassword;
        return this;
    }

    public final J4pClientBuilder singleConnection() {
        this.pooledConnections = false;
        return this;
    }

    public final J4pClientBuilder pooledConnections() {
        this.pooledConnections = true;
        return this;
    }

    public final J4pClientBuilder connectionTimeout(int pTimeOut) {
        this.connectionTimeout = pTimeOut;
        return this;
    }

    public final J4pClientBuilder socketTimeout(int pTimeOut) {
        this.socketTimeout = pTimeOut;
        return this;
    }

    public final J4pClientBuilder maxTotalConnections(int pConnections) {
        this.maxTotalConnections = pConnections;
        return this;
    }

    public final J4pClientBuilder maxConnectionPoolTimeout(int pConnectionPoolTimeout) {
        this.maxConnectionPoolTimeout = pConnectionPoolTimeout;
        return this;
    }

    public final J4pClientBuilder contentCharset(String pContentCharset) {
        return this.contentCharset(Charset.forName(pContentCharset));
    }

    public final J4pClientBuilder contentCharset(Charset pContentCharset) {
        this.contentCharset = pContentCharset;
        return this;
    }

    public final J4pClientBuilder expectContinue(boolean pUse) {
        this.expectContinue = pUse;
        return this;
    }

    public final J4pClientBuilder tcpNoDelay(boolean pUse) {
        this.tcpNoDelay = pUse;
        return this;
    }

    public final J4pClientBuilder socketBufferSize(int pSize) {
        this.socketBufferSize = pSize;
        return this;
    }

    public final J4pClientBuilder cookieStore(CookieStore pCookieStore) {
        this.cookieStore = pCookieStore;
        return this;
    }

    public final J4pClientBuilder authenticator(J4pAuthenticator pAuthenticator) {
        this.authenticator = pAuthenticator;
        return this;
    }

    public J4pClient build() {
        return new J4pClient(this.url, this.createHttpClient(), this.targetUrl != null ? new J4pTargetConfig(this.targetUrl, this.targetUser, this.targetPassword) : null);
    }

    public HttpClient createHttpClient() {
        HttpClientConnectionManager connManager = this.pooledConnections ? this.createPoolingConnectionManager() : this.createBasicConnectionManager();
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager(connManager).setDefaultCookieStore(this.cookieStore).setUserAgent("Jolokia JMX-Client (using Apache-HttpClient/" + this.getVersionInfo() + ")").setDefaultRequestConfig(this.createRequestConfig());
        if (this.user != null && this.authenticator != null) {
            this.authenticator.authenticate(builder, this.user, this.password);
        }
        return builder.build();
    }

    private String getVersionInfo() {
        VersionInfo vi = VersionInfo.loadVersionInfo("org.apache.http.client", this.getClass().getClassLoader());
        return vi != null ? vi.getRelease() : "UNAVAILABLE";
    }

    private RequestConfig createRequestConfig() {
        RequestConfig.Builder requestConfigB = RequestConfig.custom();
        requestConfigB.setExpectContinueEnabled(this.expectContinue);
        if (this.socketTimeout > -1) {
            requestConfigB.setSocketTimeout(this.socketTimeout);
        }
        if (this.connectionTimeout > -1) {
            requestConfigB.setConnectTimeout(this.connectionTimeout);
        }
        if (this.maxConnectionPoolTimeout > -1) {
            requestConfigB.setConnectionRequestTimeout(this.maxConnectionPoolTimeout);
        }
        return requestConfigB.build();
    }

    private BasicHttpClientConnectionManager createBasicConnectionManager() {
        BasicHttpClientConnectionManager connManager = new BasicHttpClientConnectionManager(this.getSocketFactoryRegistry(), this.getConnectionFactory());
        connManager.setSocketConfig(this.createSocketConfig());
        connManager.setConnectionConfig(this.createConnectionConfig());
        return connManager;
    }

    private PoolingHttpClientConnectionManager createPoolingConnectionManager() {
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(this.getSocketFactoryRegistry(), this.getConnectionFactory());
        connManager.setDefaultSocketConfig(this.createSocketConfig());
        connManager.setDefaultConnectionConfig(this.createConnectionConfig());
        if (this.maxTotalConnections != 0) {
            connManager.setMaxTotal(this.maxTotalConnections);
        }
        return connManager;
    }

    private ConnectionConfig createConnectionConfig() {
        return ConnectionConfig.custom().setBufferSize(this.socketBufferSize).setCharset(this.contentCharset).build();
    }

    private SocketConfig createSocketConfig() {
        SocketConfig.Builder socketConfigB = SocketConfig.custom();
        if (this.socketTimeout >= 0) {
            socketConfigB.setSoTimeout(this.socketTimeout);
        }
        socketConfigB.setTcpNoDelay(this.tcpNoDelay);
        return socketConfigB.build();
    }

    private Registry<ConnectionSocketFactory> getSocketFactoryRegistry() {
        SSLContext sslcontext = SSLContexts.createSystemDefault();
        BrowserCompatHostnameVerifier hostnameVerifier = new BrowserCompatHostnameVerifier();
        return RegistryBuilder.create().register("http", PlainConnectionSocketFactory.INSTANCE).register("https", (PlainConnectionSocketFactory)((Object)new SSLConnectionSocketFactory(sslcontext, (X509HostnameVerifier)hostnameVerifier))).build();
    }

    private HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> getConnectionFactory() {
        return new ManagedHttpClientConnectionFactory(new DefaultHttpRequestWriterFactory(), new DefaultHttpResponseParserFactory());
    }
}

