/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.gravia.runtime.AllServiceListener;
import org.jboss.gravia.runtime.ConstantsHelper;
import org.jboss.gravia.runtime.Filter;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ModuleEvent;
import org.jboss.gravia.runtime.ModuleListener;
import org.jboss.gravia.runtime.ServiceEvent;
import org.jboss.gravia.runtime.ServiceListener;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.SynchronousModuleListener;
import org.jboss.gravia.runtime.spi.FilterFactory;
import org.jboss.gravia.runtime.spi.NoFilter;
import org.jboss.gravia.runtime.spi.RuntimeLogger;
import org.jboss.gravia.utils.RemoveOnlyCollection;
import org.jboss.gravia.utils.RemoveOnlyMap;

public final class RuntimeEventsManager {
    private final ExecutorService executorService;
    private final Map<Module, List<ModuleListenerRegistration>> moduleListeners = new ConcurrentHashMap<Module, List<ModuleListenerRegistration>>();
    private final Map<Module, List<ServiceListenerRegistration>> serviceListeners = new ConcurrentHashMap<Module, List<ServiceListenerRegistration>>();
    private Set<Integer> asyncBundleEvents = new HashSet<Integer>();
    private Set<String> infoEvents = new HashSet<String>();

    RuntimeEventsManager() {
        this.asyncBundleEvents.add(new Integer(1));
        this.asyncBundleEvents.add(new Integer(2));
        this.asyncBundleEvents.add(new Integer(4));
        this.asyncBundleEvents.add(new Integer(16));
        this.infoEvents.add(ConstantsHelper.moduleEvent(1));
        this.infoEvents.add(ConstantsHelper.moduleEvent(2));
        this.infoEvents.add(ConstantsHelper.moduleEvent(4));
        this.infoEvents.add(ConstantsHelper.moduleEvent(16));
        this.executorService = this.createExecutorService("RuntimeEvents");
    }

    private ExecutorService createExecutorService(final String threadName) {
        ExecutorService service = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable run) {
                Thread thread = new Thread(run);
                thread.setName(threadName);
                return thread;
            }
        });
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModuleListener(Module module, ModuleListener listener) {
        assert (listener != null) : "Null listener";
        Map<Module, List<ModuleListenerRegistration>> map = this.moduleListeners;
        synchronized (map) {
            ModuleListenerRegistration registration;
            List<ModuleListenerRegistration> registrations = this.moduleListeners.get(module);
            if (registrations == null) {
                registrations = new CopyOnWriteArrayList<ModuleListenerRegistration>();
                this.moduleListeners.put(module, registrations);
            }
            if (!registrations.contains(registration = new ModuleListenerRegistration(module, listener))) {
                registrations.add(registration);
            }
        }
    }

    public void removeModuleListener(Module module, ModuleListener listener) {
        assert (listener != null) : "Null listener";
        List<ModuleListenerRegistration> registrations = this.moduleListeners.get(module);
        if (registrations != null) {
            if (registrations.size() > 1) {
                Iterator<ModuleListenerRegistration> iterator = registrations.iterator();
                while (iterator.hasNext()) {
                    ModuleListenerRegistration registration = iterator.next();
                    if (registration.getListener() != listener) continue;
                    iterator.remove();
                    break;
                }
            } else {
                this.removeBundleListeners(module);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundleListeners(Module moduleState) {
        Map<Module, List<ModuleListenerRegistration>> map = this.moduleListeners;
        synchronized (map) {
            this.moduleListeners.remove(moduleState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllBundleListeners() {
        Map<Module, List<ModuleListenerRegistration>> map = this.moduleListeners;
        synchronized (map) {
            this.moduleListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(Module module, ServiceListener listener, String filterstr) {
        assert (listener != null) : "Null listener";
        Map<Module, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            List<ServiceListenerRegistration> listeners = this.serviceListeners.get(module);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<ServiceListenerRegistration>();
                this.serviceListeners.put(module, listeners);
            }
            this.removeServiceListener(module, listener);
            Filter filter = filterstr != null ? FilterFactory.createFilter(filterstr) : NoFilter.INSTANCE;
            ServiceListenerRegistration slreg = new ServiceListenerRegistration(module, listener, filter);
            listeners.add(slreg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<ListenerInfo> getServiceListenerInfos(Module moduleState) {
        ArrayList<ListenerInfo> listeners = new ArrayList<ListenerInfo>();
        Map<Module, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            for (Map.Entry<Module, List<ServiceListenerRegistration>> entry : this.serviceListeners.entrySet()) {
                if (moduleState != null && !moduleState.equals(entry.getKey())) continue;
                for (ServiceListenerRegistration aux : entry.getValue()) {
                    ListenerInfo info = aux.getListenerInfo();
                    listeners.add(info);
                }
            }
        }
        return Collections.unmodifiableCollection(listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(Module moduleState, ServiceListener listener) {
        assert (listener != null) : "Null listener";
        Map<Module, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            ServiceListenerRegistration slreg;
            int index;
            List<ServiceListenerRegistration> listeners = this.serviceListeners.get(moduleState);
            if (listeners != null && (index = listeners.indexOf(slreg = new ServiceListenerRegistration(moduleState, listener, NoFilter.INSTANCE))) >= 0) {
                slreg = listeners.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListeners(Module moduleState) {
        Map<Module, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            this.serviceListeners.remove(moduleState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllServiceListeners() {
        Map<Module, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            this.serviceListeners.clear();
        }
    }

    public void fireModuleEvent(Module module, int type) {
        this.fireModuleEvent(null, module, type);
    }

    public void fireModuleEvent(ModuleContext context, final Module module, final int type) {
        if (module == null) {
            throw new IllegalArgumentException("module");
        }
        final ArrayList<ModuleListenerRegistration> registrations = new ArrayList<ModuleListenerRegistration>();
        for (Map.Entry<Module, List<ModuleListenerRegistration>> entry : this.moduleListeners.entrySet()) {
            for (ModuleListenerRegistration blreg : entry.getValue()) {
                registrations.add(blreg);
            }
        }
        final ModuleEventImpl event = new ModuleEventImpl(type, module);
        final String typeName = ConstantsHelper.moduleEvent(event.getType());
        Iterator iterator = registrations.iterator();
        if (registrations.isEmpty()) {
            return;
        }
        iterator = registrations.iterator();
        while (iterator.hasNext()) {
            ModuleListenerRegistration blreg;
            blreg = (ModuleListenerRegistration)iterator.next();
            ModuleListener listener = blreg.listener;
            try {
                if (!(listener instanceof SynchronousModuleListener)) continue;
                iterator.remove();
                listener.moduleChanged(event);
            }
            catch (Throwable th) {
                RuntimeLogger.LOGGER.warn("Error while firing module event " + typeName + " for: " + module, th);
            }
        }
        if (!registrations.isEmpty()) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    if (RuntimeEventsManager.this.asyncBundleEvents.contains(type)) {
                        for (ModuleListenerRegistration blreg : registrations) {
                            ModuleListener listener = blreg.listener;
                            try {
                                if (listener instanceof SynchronousModuleListener) continue;
                                listener.moduleChanged(event);
                            }
                            catch (Throwable th) {
                                RuntimeLogger.LOGGER.warn("Error while firing module event " + typeName + " for: " + module, th);
                            }
                        }
                    }
                }
            };
            if (!this.executorService.isShutdown()) {
                this.executorService.execute(runner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireServiceEvent(Module module, int type, ServiceReference<?> reference) {
        Map<ModuleContext, ArrayList<ListenerInfo>> listeners = new HashMap();
        Map<Module, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            for (Map.Entry<Module, List<ServiceListenerRegistration>> entry : this.serviceListeners.entrySet()) {
                for (ServiceListenerRegistration listener : entry.getValue()) {
                    ModuleContext context = listener.getModuleContext();
                    if (context == null) continue;
                    ArrayList<ListenerInfo> infos = (ArrayList<ListenerInfo>)listeners.get(context);
                    if (infos == null) {
                        infos = new ArrayList<ListenerInfo>();
                        listeners.put(context, infos);
                    }
                    infos.add(listener.getListenerInfo());
                }
            }
        }
        for (Map.Entry entry : listeners.entrySet()) {
            listeners.put((ModuleContext)entry.getKey(), (ArrayList<ListenerInfo>)((Object)new RemoveOnlyCollection((Collection)entry.getValue())));
        }
        listeners = new RemoveOnlyMap(listeners);
        ServiceEventImpl event = new ServiceEventImpl(type, reference);
        String typeName = ConstantsHelper.serviceEvent(event.getType());
        RuntimeLogger.LOGGER.trace("Service {}: {}", (Object)typeName, (Object)reference);
        if (listeners.isEmpty()) {
            return;
        }
        for (Map.Entry entry : listeners.entrySet()) {
            for (ListenerInfo info : (Collection)entry.getValue()) {
                ServiceListenerRegistration listenerReg = info.getRegistration();
                Module owner = info.getModuleContext().getModule();
                if (owner.getState() == Module.State.UNINSTALLED) continue;
                if (!listenerReg.isAllServiceListener()) {
                    String[] clazzes;
                    boolean assignableToOwner = true;
                    for (String clazz : clazzes = (String[])reference.getProperty("objectClass")) {
                        if (reference.isAssignableTo(owner, clazz)) continue;
                        assignableToOwner = false;
                        break;
                    }
                    if (!assignableToOwner) continue;
                }
                try {
                    Filter filter;
                    String filterstr = info.getFilter();
                    ServiceListener listener = listenerReg.getListener();
                    if (listenerReg.isAllServiceListener() || listenerReg.filter.match(reference)) {
                        listener.serviceChanged(event);
                        continue;
                    }
                    if (filterstr == null || 2 != event.getType() || (filter = listenerReg.filter).match(reference)) continue;
                    ServiceEventImpl endmatch = new ServiceEventImpl(8, reference);
                    listener.serviceChanged(endmatch);
                }
                catch (Throwable th) {
                    RuntimeLogger.LOGGER.warn("Error while firing service event " + typeName + " for: " + reference, th);
                }
            }
        }
    }

    private static class ServiceEventImpl
    extends ServiceEvent {
        private static final long serialVersionUID = 62018288275708239L;

        ServiceEventImpl(int type, ServiceReference<?> reference) {
            super(type, reference);
        }

        @Override
        public String toString() {
            return "ServiceEvent[type=" + ConstantsHelper.serviceEvent(this.getType()) + ",source=" + this.getSource() + "]";
        }
    }

    private static class ModuleEventImpl
    extends ModuleEvent {
        private static final long serialVersionUID = -2705304702665185935L;

        ModuleEventImpl(int type, Module module) {
            super(type, module);
        }

        @Override
        public String toString() {
            return "BundleEvent[type=" + ConstantsHelper.moduleEvent(this.getType()) + ",source=" + this.getSource() + "]";
        }
    }

    private static class ListenerInfo {
        private final ServiceListenerRegistration registration;
        private final ModuleContext moduleContext;
        private boolean removed;

        ListenerInfo(ModuleContext moduleContext, ServiceListenerRegistration registration) {
            this.moduleContext = moduleContext;
            this.registration = registration;
        }

        ModuleContext getModuleContext() {
            return this.moduleContext;
        }

        String getFilter() {
            Filter filter = this.registration.filter;
            return filter != NoFilter.INSTANCE ? filter.toString() : null;
        }

        ServiceListenerRegistration getRegistration() {
            return this.registration;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public String toString() {
            String className = this.registration.listener.getClass().getName();
            return "ListenerInfo[" + this.moduleContext.getModule() + "," + className + "," + this.removed + "]";
        }
    }

    private static class ModuleListenerRegistration {
        private final ModuleListener listener;
        private final Module module;

        ModuleListenerRegistration(Module module, ModuleListener listener) {
            this.listener = listener;
            this.module = module;
        }

        ModuleListener getListener() {
            return this.listener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ModuleListenerRegistration)) {
                return false;
            }
            ModuleListenerRegistration other = (ModuleListenerRegistration)obj;
            return other.listener.equals(this.listener);
        }

        public String toString() {
            String className = this.listener.getClass().getName();
            return "BundleListener[" + this.module + "," + className + "]";
        }
    }

    private static class ServiceListenerRegistration {
        private final Module module;
        private final ModuleContext moduleContext;
        private final ServiceListener listener;
        private final Filter filter;
        private final ListenerInfo info;

        ServiceListenerRegistration(Module module, ServiceListener listener, Filter filter) {
            assert (module != null) : "Null module";
            assert (listener != null) : "Null listener";
            assert (filter != null) : "Null filter";
            this.module = module;
            this.listener = listener;
            this.filter = filter;
            this.moduleContext = module.getModuleContext();
            this.info = new ListenerInfo(this.moduleContext, this);
        }

        Module getModule() {
            return this.module;
        }

        ModuleContext getModuleContext() {
            return this.getModule().getModuleContext();
        }

        ServiceListener getListener() {
            return this.listener;
        }

        ListenerInfo getListenerInfo() {
            return this.info;
        }

        boolean isAllServiceListener() {
            return this.listener instanceof AllServiceListener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ServiceListenerRegistration)) {
                return false;
            }
            ServiceListenerRegistration other = (ServiceListenerRegistration)obj;
            return other.listener.equals(this.listener);
        }

        public String toString() {
            String className = this.listener.getClass().getName();
            return "ServiceListener[" + this.module + "," + className + "," + this.filter + "]";
        }
    }
}

