/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.spi;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.gravia.runtime.spi.CompositePropertiesProvider;
import org.jboss.gravia.runtime.spi.EnvPropertiesProvider;
import org.jboss.gravia.runtime.spi.MapPropertiesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.SecurityActions;
import org.jboss.gravia.runtime.spi.SubstitutionPropertiesProvider;
import org.jboss.gravia.runtime.spi.SystemPropertiesProvider;
import org.jboss.gravia.utils.IllegalArgumentAssertion;

public class DefaultPropertiesProvider
extends CompositePropertiesProvider {
    private final PropertiesProvider delegate;

    public DefaultPropertiesProvider() {
        this(new HashMap<String, Object>());
    }

    public DefaultPropertiesProvider(Properties properties) {
        this(DefaultPropertiesProvider.propsToMap(properties));
    }

    public DefaultPropertiesProvider(Map<String, Object> properties) {
        this(properties, true);
    }

    public DefaultPropertiesProvider(Properties properties, boolean systemPropertyDelegation) {
        this(DefaultPropertiesProvider.propsToMap(properties), systemPropertyDelegation, null);
    }

    public DefaultPropertiesProvider(Map<String, Object> properties, boolean systemPropertyDelegation) {
        this(properties, systemPropertyDelegation, null);
    }

    public DefaultPropertiesProvider(Properties properties, boolean systemPropertyDelegation, String environmentVariablePrefix) {
        this(DefaultPropertiesProvider.propsToMap(properties), systemPropertyDelegation, environmentVariablePrefix);
    }

    public DefaultPropertiesProvider(Map<String, Object> properties, boolean systemPropertyDelegation, String environmentVariablePrefix) {
        super(new PropertiesProvider[0]);
        IllegalArgumentAssertion.assertNotNull(properties, "props");
        properties.putAll(DefaultPropertiesProvider.propsToMap(DefaultPropertiesProvider.getDefaultProperties()));
        this.delegate = new SubstitutionPropertiesProvider(new CompositePropertiesProvider(new MapPropertiesProvider(properties), systemPropertyDelegation ? new SystemPropertiesProvider() : new MapPropertiesProvider(), new EnvPropertiesProvider(environmentVariablePrefix)));
    }

    @Override
    public Object getProperty(String key) {
        return this.delegate.getProperty(key, null);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        return this.delegate.getProperty(key, defaultValue);
    }

    private static Properties getDefaultProperties() {
        URL configURL = null;
        String sysprop = SecurityActions.getSystemProperty("gravia.properties", null);
        if (sysprop != null) {
            try {
                configURL = new URL(sysprop);
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException("Invalid configuration URL: " + sysprop);
            }
        }
        if (configURL == null) {
            ClassLoader classLoader = DefaultPropertiesProvider.class.getClassLoader();
            configURL = classLoader.getResource("gravia.properties");
        }
        Properties props = new Properties();
        if (configURL != null) {
            try {
                props.load(configURL.openStream());
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot load configuration from: " + configURL, ex);
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> propsToMap(Properties props) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Properties properties = props;
        synchronized (properties) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                result.put(key, value);
            }
        }
        return result;
    }
}

