/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.scr;

import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.InvalidComponentException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ValidatingReference<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatingReference.class);
    private final AtomicReference<T> reference = new AtomicReference();

    public void bind(T ref) {
        LOG.debug("bind: {}", (Object)ref);
        this.reference.set(ref);
    }

    public void unbind(T ref) {
        LOG.debug("unbind: {}", (Object)ref);
        this.reference.compareAndSet(ref, null);
    }

    public T get() {
        T ref = this.reference.get();
        if (ref == null) {
            throw new InvalidComponentException("Reference not available");
        }
        return ref;
    }

    public T getOptional() {
        return this.reference.get();
    }
}

