/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.jmx;

import io.fabric8.api.jmx.MetaTypeObjectSummaryDTO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.ObjectClassDefinition;

public class MetaTypeSummaryDTO {
    private Map<String, MetaTypeObjectSummaryDTO> pids = new HashMap<String, MetaTypeObjectSummaryDTO>();
    private Set<String> locales = new HashSet<String>();

    public void addTypeInformation(Bundle bundle, MetaTypeInformation info) {
        this.addBundleInfo(bundle, info, info.getFactoryPids(), true);
        this.addBundleInfo(bundle, info, info.getPids(), false);
        String[] localeArray = info.getLocales();
        if (localeArray != null) {
            for (String locale : localeArray) {
                this.locales.add(locale);
            }
        }
    }

    public Map<String, MetaTypeObjectSummaryDTO> getPids() {
        return this.pids;
    }

    public void setPids(Map<String, MetaTypeObjectSummaryDTO> pids) {
        this.pids = pids;
    }

    public Set<String> getLocales() {
        return this.locales;
    }

    private void addBundleInfo(Bundle bundle, MetaTypeInformation info, String[] pids, boolean factory) {
        String locale = null;
        if (pids != null) {
            long bundleId = bundle.getBundleId();
            for (String pid : pids) {
                MetaTypeObjectSummaryDTO summary = this.pids.get(pid);
                if (summary == null) {
                    summary = new MetaTypeObjectSummaryDTO(pid);
                    this.pids.put(pid, summary);
                }
                if (factory) {
                    summary.getFactoryPidBundleIds().add(bundleId);
                } else {
                    summary.getPidBundleIds().add(bundleId);
                }
                ObjectClassDefinition objectClassDefinition = MetaTypeSummaryDTO.tryGetObjectClassDefinition(info, pid, locale);
                if (objectClassDefinition == null) continue;
                summary.appendObjectDefinition(objectClassDefinition);
            }
        }
    }

    public static ObjectClassDefinition tryGetObjectClassDefinition(MetaTypeInformation info, String pid, String locale) {
        ObjectClassDefinition object = null;
        try {
            object = info.getObjectClassDefinition(pid, locale);
        }
        catch (Exception e) {
            // empty catch block
        }
        return object;
    }
}

