/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import io.fabric8.api.AutoScaleStatus;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricRequirements;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface DataStore {
    public static final String ATTRIBUTE_PREFIX = "attribute.";
    public static final String DATASTORE_TYPE_PROPERTY = "type";
    public static final String DEFAULT_DATASTORE_TYPE = "caching-git";

    public String getFabricReleaseVersion();

    public String getType();

    public void importFromFileSystem(String var1);

    public void trackConfiguration(Runnable var1);

    public void untrackConfiguration(Runnable var1);

    public List<String> getContainers();

    public boolean hasContainer(String var1);

    public String getContainerParent(String var1);

    public void deleteContainer(String var1);

    public void createContainerConfig(CreateContainerOptions var1);

    public void createContainerConfig(CreateContainerMetadata var1);

    public CreateContainerMetadata getContainerMetadata(String var1, ClassLoader var2);

    public void setContainerMetadata(CreateContainerMetadata var1);

    public String getContainerVersion(String var1);

    public void setContainerVersion(String var1, String var2);

    public List<String> getContainerProfiles(String var1);

    public void setContainerProfiles(String var1, List<String> var2);

    public boolean isContainerAlive(String var1);

    public void setContainerAlive(String var1, boolean var2);

    public String getContainerAttribute(String var1, ContainerAttribute var2, String var3, boolean var4, boolean var5);

    public void setContainerAttribute(String var1, ContainerAttribute var2, String var3);

    public String getDefaultVersion();

    public void setDefaultVersion(String var1);

    public List<String> getVersions();

    public boolean hasVersion(String var1);

    public void createVersion(String var1);

    public void createVersion(String var1, String var2);

    public void deleteVersion(String var1);

    public Map<String, String> getVersionAttributes(String var1);

    public void setVersionAttribute(String var1, String var2, String var3);

    public List<String> getProfiles(String var1);

    public boolean hasProfile(String var1, String var2);

    public void importProfiles(String var1, List<String> var2);

    public void exportProfiles(String var1, String var2, String var3);

    public void createProfile(String var1, String var2);

    public String getProfile(String var1, String var2, boolean var3);

    public void deleteProfile(String var1, String var2);

    public Map<String, String> getProfileAttributes(String var1, String var2);

    public void setProfileAttribute(String var1, String var2, String var3, String var4);

    public String getLastModified(String var1, String var2);

    public Collection<String> listFiles(String var1, Iterable<String> var2, String var3);

    public List<String> getConfigurationFileNames(String var1, String var2);

    public Map<String, byte[]> getFileConfigurations(String var1, String var2);

    public byte[] getFileConfiguration(String var1, String var2, String var3);

    public void setFileConfigurations(String var1, String var2, Map<String, byte[]> var3);

    public void setFileConfiguration(String var1, String var2, String var3, byte[] var4);

    public Map<String, Map<String, String>> getConfigurations(String var1, String var2);

    public Map<String, String> getConfiguration(String var1, String var2, String var3);

    public void setConfigurations(String var1, String var2, Map<String, Map<String, String>> var3);

    public void setConfiguration(String var1, String var2, String var3, Map<String, String> var4);

    public void setConfigurationFile(String var1, String var2, String var3, byte[] var4);

    public String getDefaultJvmOptions();

    public void setDefaultJvmOptions(String var1);

    public FabricRequirements getRequirements();

    public void setRequirements(FabricRequirements var1) throws IOException;

    public AutoScaleStatus getAutoScaleStatus();

    public String getClusterId();

    public List<String> getEnsembleContainers();

    public Map<String, String> getDataStoreProperties();

    public static enum ContainerAttribute {
        BlueprintStatus,
        SpringStatus,
        ProvisionStatus,
        ProvisionException,
        ProvisionList,
        ProvisionChecksums,
        DebugPort,
        Location,
        GeoLocation,
        Resolver,
        Ip,
        LocalIp,
        LocalHostName,
        PublicIp,
        PublicHostName,
        ManualIp,
        BindAddress,
        SshUrl,
        JmxUrl,
        JolokiaUrl,
        HttpUrl,
        PortMin,
        PortMax,
        Domains,
        ProcessId,
        OpenShift;

    }
}

