/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jolokia.facade.facades;

import io.fabric8.api.Container;
import io.fabric8.api.HasId;
import io.fabric8.api.Profile;
import io.fabric8.jolokia.facade.utils.Helpers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import org.jolokia.client.J4pClient;
import org.jolokia.client.exception.J4pException;
import org.jolokia.client.request.J4pExecRequest;
import org.jolokia.client.request.J4pExecResponse;

public class ProfileFacade
implements Profile,
HasId {
    J4pClient j4p;
    String id;
    String versionId;

    public ProfileFacade(J4pClient j4p, String versionId, String id) {
        this.j4p = j4p;
        this.versionId = versionId;
        this.id = id;
    }

    private static <T> T getFieldValue(J4pClient j4p, String operation, String versionId, String id, String field) {
        T rc = null;
        try {
            J4pExecRequest request = Helpers.createExecRequest(operation, versionId, id, Helpers.toList(field));
            J4pExecResponse response = (J4pExecResponse)j4p.execute(request);
            Map value = (Map)response.getValue();
            rc = (T)value.get(field);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Failed to get container field", e);
        }
        catch (J4pException e) {
            throw new RuntimeException("Failed to get container field", e);
        }
        return rc;
    }

    private <T> T getFieldValue(String field) {
        return ProfileFacade.getFieldValue(this.j4p, "getProfile(java.lang.String, java.lang.String, java.util.List)", this.versionId, this.id, field);
    }

    @Override
    public String getVersion() {
        return this.versionId;
    }

    @Override
    public Map<String, String> getAttributes() {
        return (Map)this.getFieldValue("attributes");
    }

    @Override
    public void setAttribute(String s, String s2) {
        throw new UnsupportedOperationException("The method is not yet implemented.");
    }

    @Override
    public Profile[] getParents() {
        List profiles = (List)this.getFieldValue("parents");
        if (profiles == null || profiles.size() == 0) {
            return new Profile[0];
        }
        ArrayList<ProfileFacade> answer = new ArrayList<ProfileFacade>();
        for (Object profile : profiles) {
            answer.add(new ProfileFacade(this.j4p, this.versionId, (String)profile));
        }
        return answer.toArray(new Profile[answer.size()]);
    }

    @Override
    public void setParents(Profile[] profiles) {
        ArrayList<String> parentIds = new ArrayList<String>();
        for (Profile profile : profiles) {
            parentIds.add(profile.getId());
        }
        Helpers.exec(this.j4p, "changeProfileParents(java.lang.String, java.lang.String, java.util.List)", this.versionId, this.id, parentIds);
    }

    @Override
    public void refresh() {
        Helpers.exec(this.j4p, "refreshProfile", this.versionId, this.id);
    }

    @Override
    public Container[] getAssociatedContainers() {
        throw new UnsupportedOperationException("The method is not yet implemented.");
    }

    @Override
    public List<String> getLibraries() {
        return (List)this.getFieldValue("libraries");
    }

    @Override
    public List<String> getEndorsedLibraries() {
        return (List)this.getFieldValue("endorsedLibraries");
    }

    @Override
    public List<String> getExtensionLibraries() {
        return (List)this.getFieldValue("extensionLibraries");
    }

    @Override
    public List<String> getBundles() {
        return (List)this.getFieldValue("bundles");
    }

    @Override
    public List<String> getFabs() {
        return (List)this.getFieldValue("fabs");
    }

    @Override
    public List<String> getFeatures() {
        return (List)this.getFieldValue("features");
    }

    @Override
    public List<String> getRepositories() {
        return (List)this.getFieldValue("repositories");
    }

    @Override
    public List<String> getOverrides() {
        return (List)this.getFieldValue("overrides");
    }

    @Override
    public List<String> getConfigurationFileNames() {
        throw new UnsupportedOperationException("The method is not yet implemented.");
    }

    @Override
    public Map<String, byte[]> getFileConfigurations() {
        throw new UnsupportedOperationException("The method is not yet implemented.");
    }

    @Override
    public byte[] getFileConfiguration(String fileName) {
        throw new UnsupportedOperationException("The method is not yet implemented.");
    }

    @Override
    public void setFileConfigurations(Map<String, byte[]> stringMap) {
        throw new UnsupportedOperationException("The method is not yet implemented.");
    }

    @Override
    public Map<String, Map<String, String>> getConfigurations() {
        throw new UnsupportedOperationException("The method is not yet implemented.");
    }

    @Override
    public Map<String, String> getContainerConfiguration() {
        return (Map)this.getFieldValue("containerConfiguration");
    }

    @Override
    public void setConfigurations(Map<String, Map<String, String>> stringMapMap) {
        throw new UnsupportedOperationException("The method is not yet implemented.");
    }

    @Override
    public Profile getOverlay() {
        throw new UnsupportedOperationException("The method is not yet implemented.");
    }

    @Override
    public Profile getOverlay(boolean substitute) {
        throw new UnsupportedOperationException("The method is not yet implemented.");
    }

    @Override
    public boolean isOverlay() {
        return (Boolean)this.getFieldValue("overlay");
    }

    @Override
    public void delete() {
        Void v = (Void)Helpers.exec(this.j4p, "deleteProfile(java.lang.String, java.lang.String)", this.versionId, this.id);
    }

    @Override
    public void delete(boolean b) {
        Void v = (Void)Helpers.exec(this.j4p, "deleteProfile(java.lang.String, java.lang.String)", this.versionId, this.id);
    }

    @Override
    public void setBundles(List<String> strings) {
        Void v = (Void)Helpers.exec(this.j4p, "setProfileBundles(java.lang.String, java.lang.String, java.util.List)", this.versionId, this.id, strings);
    }

    @Override
    public void setFabs(List<String> strings) {
        Void v = (Void)Helpers.exec(this.j4p, "setProfileFabs(java.lang.String, java.lang.String, java.util.List)", this.versionId, this.id, strings);
    }

    @Override
    public void setFeatures(List<String> strings) {
        Void v = (Void)Helpers.exec(this.j4p, "setProfileFeatures(java.lang.String, java.lang.String, java.util.List)", this.versionId, this.id, strings);
    }

    @Override
    public void setRepositories(List<String> strings) {
        Void v = (Void)Helpers.exec(this.j4p, "setProfileRepositories(java.lang.String, java.lang.String, java.util.List)", this.versionId, this.id, strings);
    }

    @Override
    public void setOverrides(List<String> strings) {
        Void v = (Void)Helpers.exec(this.j4p, "setProfileOverrides(java.lang.String, java.lang.String, java.util.List)", this.versionId, this.id, strings);
    }

    @Override
    public boolean configurationEquals(Profile profile) {
        throw new UnsupportedOperationException("The method is not yet implemented.");
    }

    @Override
    public boolean agentConfigurationEquals(Profile profile) {
        throw new UnsupportedOperationException("The method is not yet implemented.");
    }

    @Override
    public boolean isAbstract() {
        return (Boolean)this.getFieldValue("abstract");
    }

    @Override
    public boolean isLocked() {
        return (Boolean)this.getFieldValue("locked");
    }

    @Override
    public boolean isHidden() {
        return (Boolean)this.getFieldValue("hidden");
    }

    @Override
    public String getProfileHash() {
        return (String)this.getFieldValue("lastModified");
    }

    @Override
    public int compareTo(Profile profile) {
        throw new UnsupportedOperationException("The method is not yet implemented.");
    }

    @Override
    public boolean exists() {
        throw new UnsupportedOperationException("The method is not yet implemented.");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Map<String, String> getConfiguration(String pid) {
        Map<String, Map<String, String>> configurations = this.getConfigurations();
        if (configurations != null) {
            return configurations.get(pid);
        }
        return null;
    }

    @Override
    public void setConfiguration(String pid, Map<String, String> configuration) {
        Map<String, Map<String, String>> configurations = this.getConfigurations();
        if (configurations != null) {
            configurations.put(pid, configuration);
            this.setConfigurations(configurations);
        }
    }

    @Override
    public void setConfigurationFile(String fileName, byte[] data) {
        throw new UnsupportedOperationException("The method is not yet implemented.");
    }
}

