/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Profiles {
    public static final boolean useDirectoriesForProfiles = true;
    public static final String PROFILE_FOLDER_SUFFIX = ".profile";

    public static List<String> profileIds(Iterable<Profile> profiles) {
        ArrayList<String> answer = new ArrayList<String>();
        if (profiles != null) {
            for (Profile profile : profiles) {
                answer.add(profile.getId());
            }
        }
        return answer;
    }

    public static List<String> profileIds(Profile ... profiles) {
        ArrayList<String> answer = new ArrayList<String>();
        if (profiles != null) {
            for (Profile profile : profiles) {
                answer.add(profile.getId());
            }
        }
        return answer;
    }

    public static String versionId(Version version) {
        return version != null ? version.getId() : null;
    }

    public static List<String> versionIds(Version ... versions) {
        ArrayList<String> answer = new ArrayList<String>();
        if (versions != null) {
            for (Version version : versions) {
                answer.add(version.getId());
            }
        }
        return answer;
    }

    public static List<String> versionIds(Iterable<Version> versions) {
        ArrayList<String> answer = new ArrayList<String>();
        if (versions != null) {
            for (Version version : versions) {
                answer.add(version.getId());
            }
        }
        return answer;
    }

    public static Profile profile(Profile[] profiles, String profileId) {
        if (profiles != null) {
            for (Profile profile : profiles) {
                if (!profileId.equals(profile.getId())) continue;
                return profile;
            }
        }
        return null;
    }

    public static List<String> getConfigurationFileNames(Collection<Profile> profiles) {
        HashSet<String> set = new HashSet<String>();
        for (Profile profile : profiles) {
            set.addAll(profile.getConfigurationFileNames());
        }
        return new ArrayList<String>(set);
    }

    public static byte[] getFileConfiguration(Collection<Profile> profiles, String fileName) {
        Profile profile;
        byte[] answer = null;
        Iterator<Profile> i$ = profiles.iterator();
        while (i$.hasNext() && (answer = (profile = i$.next()).getFileConfiguration(fileName)) == null) {
        }
        return answer;
    }

    public static Map<String, String> getConfigurationFileNameMap(Profile[] profiles) {
        TreeMap<String, String> answer = new TreeMap<String, String>();
        for (Profile profile : profiles) {
            String id = profile.getId();
            List<String> files = profile.getConfigurationFileNames();
            for (String file : files) {
                if (answer.containsKey(file)) continue;
                answer.put(file, id);
            }
        }
        return answer;
    }

    public static Map<String, String> getOverlayConfiguration(FabricService fabricService, Iterable<String> profileIds, String versionId, String pid) {
        HashMap<String, String> overlayConfig = new HashMap<String, String>();
        Version version = null;
        version = versionId == null ? fabricService.getDefaultVersion() : fabricService.getVersion(versionId);
        if (profileIds != null && version != null) {
            for (String profileId : profileIds) {
                Profile overlay;
                Map<String, String> profileConfig;
                Profile profile = version.getProfile(profileId);
                if (profile == null || (profileConfig = (overlay = profile.getOverlay()).getConfiguration(pid)) == null) continue;
                overlayConfig.putAll(profileConfig);
            }
        }
        return overlayConfig;
    }

    public static Map<String, Map<String, String>> getOverlayFactoryConfigurations(FabricService fabricService, Iterable<String> profileIds, String versionId, String pid) {
        HashMap<String, Map<String, String>> answer = new HashMap<String, Map<String, String>>();
        Version version = null;
        version = versionId == null ? fabricService.getDefaultVersion() : fabricService.getVersion(versionId);
        String prefix = pid + "-";
        String postfix = ".properties";
        if (profileIds != null && version != null) {
            for (String profileId : profileIds) {
                Profile profile = version.getProfile(profileId);
                if (profile == null) continue;
                Profile overlay = profile.getOverlay();
                List<String> configurationFileNames = overlay.getConfigurationFileNames();
                for (String fileName : configurationFileNames) {
                    String filePid;
                    Map<String, String> profileConfig;
                    if (!fileName.startsWith(prefix) || !fileName.endsWith(postfix)) continue;
                    String name = fileName.substring(prefix.length(), fileName.length() - postfix.length());
                    HashMap<String, String> overlayConfig = (HashMap<String, String>)answer.get(name);
                    if (overlayConfig == null) {
                        overlayConfig = new HashMap<String, String>();
                        answer.put(name, overlayConfig);
                    }
                    if ((profileConfig = overlay.getConfiguration(filePid = fileName.substring(0, fileName.length() - postfix.length()))) == null) continue;
                    overlayConfig.putAll(profileConfig);
                }
            }
        }
        return answer;
    }

    public static List<Profile> getProfiles(FabricService fabricService, Iterable<String> profileIds, String versionId) {
        Version version = null;
        version = versionId == null ? fabricService.getDefaultVersion() : fabricService.getVersion(versionId);
        ArrayList<Profile> answer = new ArrayList<Profile>();
        if (profileIds != null && version != null) {
            for (String profileId : profileIds) {
                Profile profile = version.getProfile(profileId);
                if (profile == null) continue;
                answer.add(profile);
            }
        }
        return answer;
    }

    public static String convertProfileIdToPath(String profileId) {
        return profileId.replace('-', File.separatorChar) + PROFILE_FOLDER_SUFFIX;
    }
}

