/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jolokia.facade.facades;

import io.fabric8.api.HasId;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.api.VersionSequence;
import io.fabric8.jolokia.facade.facades.ProfileFacade;
import io.fabric8.jolokia.facade.utils.Helpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.jolokia.client.J4pClient;
import org.json.simple.JSONArray;

public class VersionFacade
implements Version,
HasId {
    J4pClient j4p;
    String id;
    VersionSequence sequence;

    public VersionFacade(J4pClient j4p, String id) {
        this.j4p = j4p;
        this.id = id;
        this.sequence = new VersionSequence(id);
    }

    private <T> T getFieldValue(String field) {
        return Helpers.getFieldValue(this.j4p, "getVersion(java.lang.String, java.util.List)", this.id, field);
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public Map<String, String> getAttributes() {
        return (Map)this.getFieldValue("attributes");
    }

    @Override
    public void setAttribute(String s, String s2) {
        throw new UnsupportedOperationException("The method is not yet implemented.");
    }

    @Override
    public VersionSequence getSequence() {
        return this.sequence;
    }

    @Override
    public Version getDerivedFrom() {
        String id = (String)this.getFieldValue("derivedFrom");
        if (id == null) {
            return null;
        }
        return new VersionFacade(this.j4p, id);
    }

    @Override
    public Profile[] getProfiles() {
        ArrayList<ProfileFacade> rc = new ArrayList<ProfileFacade>();
        JSONArray array = (JSONArray)this.getFieldValue("profiles");
        if (array == null || array.size() == 0) {
            return new Profile[0];
        }
        for (Object profile : array) {
            rc.add(new ProfileFacade(this.j4p, this.id, (String)profile));
        }
        return rc.toArray(new Profile[rc.size()]);
    }

    @Override
    public Profile getProfile(String s) {
        return new ProfileFacade(this.j4p, this.id, s);
    }

    @Override
    public Profile createProfile(String s) {
        Map profile = (Map)Helpers.exec(this.j4p, "createProfile(java.lang.String, java.lang.String)", this.id, s);
        if (profile == null) {
            return null;
        }
        return new ProfileFacade(this.j4p, this.id, s);
    }

    @Override
    public void copyProfile(String s, String s2, boolean b) {
        Void v = (Void)Helpers.exec(this.j4p, "copyProfile(java.lang.String, java.lang.String, java.lang.String, boolean)", this.id, s, s2, b);
    }

    @Override
    public void renameProfile(String s, String s2, boolean b) {
        Void v = (Void)Helpers.exec(this.j4p, "renameProfile(java.lang.String, java.lang.String, java.lang.String, boolean)", this.id, s, s2, b);
    }

    @Override
    public boolean hasProfile(String s) {
        String[] profiles = (String[])this.getFieldValue("profiles");
        return Arrays.asList(profiles).contains(s);
    }

    @Override
    public void delete() {
        Void v = (Void)Helpers.exec(this.j4p, "deleteVersion(java.lang.String)", this.id);
    }

    @Override
    public int compareTo(Version version) {
        return this.sequence.compareTo(version.getSequence());
    }

    @Override
    public String getId() {
        return this.id;
    }
}

