/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.boot.commands;

import io.fabric8.api.BootstrapComplete;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.JoinAction;
import io.fabric8.boot.commands.service.JoinAvailable;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(name="join", scope="fabric", description="Creates a new fabric ensemble (ZooKeeper ensemble) and imports fabric profiles", detailedDescription="classpath:join.txt")
@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class, JoinAvailable.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"join"})})
public class JoinCommand
extends AbstractCommandComponent
implements JoinAvailable {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "join";
    public static final String DESCRIPTION = "Join a container to an existing fabric";
    @Reference
    private BootstrapComplete bootComplete;
    @Reference(referenceInterface=ConfigurationAdmin.class, bind="bindConfigAdmin", unbind="unbindConfigAdmin")
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class, bind="bindRuntimeProperties", unbind="unbindRuntimeProperties")
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    private BundleContext bundleContext;

    @Activate
    void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public Action createNewAction() {
        this.assertValid();
        return new JoinAction(this.bundleContext, (ConfigurationAdmin)this.configAdmin.get(), (RuntimeProperties)this.runtimeProperties.get());
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    protected void bindBootComplete(BootstrapComplete bootstrapComplete) {
        this.bootComplete = bootstrapComplete;
    }

    protected void unbindBootComplete(BootstrapComplete bootstrapComplete) {
        if (this.bootComplete == bootstrapComplete) {
            this.bootComplete = null;
        }
    }
}

