/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.autoscale;

import io.fabric8.api.Container;
import io.fabric8.api.ContainerAutoScaler;
import io.fabric8.api.Containers;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.autoscale.AutoScalerNode;
import io.fabric8.common.util.Closeables;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.ZooKeeperGroup;
import io.fabric8.zookeeper.ZkPath;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.autoscale", label="Fabric8 auto scaler", immediate=true, metatype=false)
public final class AutoScaleController
extends AbstractComponent
implements GroupListener<AutoScalerNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoScaleController.class);
    @Reference(referenceInterface=CuratorFramework.class, bind="bindCurator", unbind="unbindCurator")
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=FabricService.class, bind="bindFabricService", unbind="unbindFabricService")
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=ContainerAutoScaler.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY, bind="bindContainerAutoScaler", unbind="unbindContainerAutoScaler")
    private final ValidatingReference<ContainerAutoScaler> containerAutoScaler = new ValidatingReference();
    @GuardedBy(value="volatile")
    private volatile Group<AutoScalerNode> group;
    private Runnable runnable = new Runnable(){

        @Override
        public void run() {
            AutoScaleController.this.onConfigurationChanged();
        }
    };

    @Activate
    void activate() {
        this.group = new ZooKeeperGroup((CuratorFramework)this.curator.get(), ZkPath.AUTO_SCALE.getPath(new String[0]), AutoScalerNode.class);
        this.group.add((GroupListener)this);
        this.group.update((NodeState)this.createState());
        this.group.start();
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        this.group.remove((GroupListener)this);
        Closeables.closeQuitely(this.group);
        this.group = null;
    }

    public void groupEvent(Group<AutoScalerNode> group, GroupListener.GroupEvent event) {
        DataStore dataStore = ((FabricService)this.fabricService.get()).getDataStore();
        switch (event) {
            case CONNECTED: 
            case CHANGED: {
                if (this.isValid()) {
                    AutoScalerNode state = this.createState();
                    try {
                        if (group.isMaster()) {
                            LOGGER.info("AutoScaleController is the master");
                            group.update((NodeState)state);
                            dataStore.trackConfiguration(this.runnable);
                            this.onConfigurationChanged();
                            break;
                        }
                        LOGGER.info("AutoScaleController is not the master");
                        group.update((NodeState)state);
                        dataStore.untrackConfiguration(this.runnable);
                    }
                    catch (IllegalStateException e) {}
                    break;
                }
                LOGGER.info("Not valid with master: " + group.isMaster() + " fabric: " + this.fabricService.get() + " curator: " + this.curator.get() + " containerAutoScaler: " + this.containerAutoScaler.get());
                break;
            }
            case DISCONNECTED: {
                dataStore.untrackConfiguration(this.runnable);
            }
        }
    }

    private void onConfigurationChanged() {
        LOGGER.info("Configuration has changed; so checking the auto-scaling requirements");
        this.autoScale();
    }

    private void autoScale() {
        ContainerAutoScaler autoScaler = this.getContainerAutoScaler();
        if (autoScaler != null) {
            FabricRequirements requirements = ((FabricService)this.fabricService.get()).getRequirements();
            List profileRequirements = requirements.getProfileRequirements();
            for (ProfileRequirements profileRequirement : profileRequirements) {
                this.autoScaleProfile(autoScaler, requirements, profileRequirement);
            }
        } else {
            LOGGER.warn("No ContainerAutoScaler available");
        }
    }

    private ContainerAutoScaler getContainerAutoScaler() {
        FabricService service;
        ContainerAutoScaler answer = null;
        if (this.containerAutoScaler != null && (answer = (ContainerAutoScaler)this.containerAutoScaler.getOptional()) == null && (service = (FabricService)this.fabricService.getOptional()) != null) {
            answer = service.createContainerAutoScaler();
            this.containerAutoScaler.bind((Object)answer);
            LOGGER.info("Creating auto scaler " + answer);
        }
        if (this.containerAutoScaler == null) {
            LOGGER.warn("No containerAutoScaler injected or could be created");
        }
        return answer;
    }

    private void autoScaleProfile(ContainerAutoScaler autoScaler, FabricRequirements requirements, ProfileRequirements profileRequirement) {
        String profile = profileRequirement.getProfile();
        Integer minimumInstances = profileRequirement.getMinimumInstances();
        if (minimumInstances != null) {
            List<Container> containers = this.containersForProfile(profile);
            int count = containers.size();
            int delta = minimumInstances - count;
            try {
                if (delta < 0) {
                    autoScaler.destroyContainers(profile, -delta, containers);
                } else if (delta > 0 && this.requirementsSatisfied(requirements, profileRequirement)) {
                    String version = ((FabricService)this.fabricService.get()).getDefaultVersion().getId();
                    autoScaler.createContainers(version, profile, delta);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to auto-scale " + profile + ". Caught: " + e, (Throwable)e);
            }
        }
    }

    private boolean requirementsSatisfied(FabricRequirements requirements, ProfileRequirements profileRequirement) {
        List dependentProfiles = profileRequirement.getDependentProfiles();
        if (dependentProfiles != null) {
            for (String dependentProfile : dependentProfiles) {
                ProfileRequirements dependentProfileRequirements = requirements.getOrCreateProfileRequirement(dependentProfile);
                Integer minimumInstances = dependentProfileRequirements.getMinimumInstances();
                if (minimumInstances == null) continue;
                List<Container> containers = this.containersForProfile(dependentProfile);
                int dependentSize = containers.size();
                if (minimumInstances <= dependentSize) continue;
                LOGGER.info("Cannot yet auto-scale profile " + profileRequirement.getProfile() + " since dependent profile " + dependentProfile + " has only " + dependentSize + " container(s) when it requires " + minimumInstances + " container(s)");
                return false;
            }
        }
        return true;
    }

    private List<Container> containersForProfile(String profile) {
        return Containers.containersForProfile((Container[])((FabricService)this.fabricService.get()).getContainers(), (String)profile);
    }

    private AutoScalerNode createState() {
        AutoScalerNode state = new AutoScalerNode();
        return state;
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindContainerAutoScaler(ContainerAutoScaler containerAutoScaler) {
        this.containerAutoScaler.bind((Object)containerAutoScaler);
    }

    void unbindContainerAutoScaler(ContainerAutoScaler containerAutoScaler) {
        this.containerAutoScaler.unbind((Object)containerAutoScaler);
    }
}

