/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.api.DockerConfiguration;
import io.fabric8.api.DockerHostConfiguration;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.SshConfiguration;
import io.fabric8.api.SshHostConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FabricRequirements {
    private List<ProfileRequirements> profileRequirements = new ArrayList<ProfileRequirements>();
    private String version;
    private SshConfiguration sshConfiguration;
    private DockerConfiguration dockerConfiguration;

    public FabricRequirements() {
    }

    public FabricRequirements(List<ProfileRequirements> profileRequirements) {
        this();
        this.profileRequirements = profileRequirements;
        this.sortProfilesRequirements();
    }

    public String toString() {
        return "FabricRequirements" + this.profileRequirements;
    }

    public List<ProfileRequirements> getProfileRequirements() {
        return this.profileRequirements;
    }

    public void setProfileRequirements(List<ProfileRequirements> profileRequirements) {
        this.profileRequirements = profileRequirements;
        this.sortProfilesRequirements();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public SshConfiguration getSshConfiguration() {
        return this.sshConfiguration;
    }

    public void setSshConfiguration(SshConfiguration sshConfiguration) {
        this.sshConfiguration = sshConfiguration;
    }

    public DockerConfiguration getDockerConfiguration() {
        return this.dockerConfiguration;
    }

    public void setDockerConfiguration(DockerConfiguration dockerConfiguration) {
        this.dockerConfiguration = dockerConfiguration;
    }

    @JsonIgnore
    public List<SshHostConfiguration> getSshHosts() {
        if (this.sshConfiguration != null) {
            return this.sshConfiguration.getHosts();
        }
        return new ArrayList<SshHostConfiguration>();
    }

    @JsonIgnore
    public List<DockerHostConfiguration> getDockerHosts() {
        if (this.dockerConfiguration != null) {
            return this.dockerConfiguration.getHosts();
        }
        return new ArrayList<DockerHostConfiguration>();
    }

    public ProfileRequirements getOrCreateProfileRequirement(String profile) {
        ProfileRequirements requirements = this.findProfileRequirements(profile);
        if (requirements == null) {
            requirements = new ProfileRequirements(profile);
            this.profileRequirements.add(requirements);
        }
        return requirements;
    }

    public ProfileRequirements findProfileRequirements(String profile) {
        for (ProfileRequirements profileRequirement : this.profileRequirements) {
            if (!profile.equals(profileRequirement.getProfile())) continue;
            return profileRequirement;
        }
        return null;
    }

    public boolean removeProfileRequirements(String profile) {
        ProfileRequirements requirements = this.findProfileRequirements(profile);
        if (requirements != null) {
            this.profileRequirements.remove(requirements);
            return true;
        }
        return false;
    }

    public void addOrUpdateProfileRequirements(ProfileRequirements requirement) {
        this.removeProfileRequirements(requirement.getProfile());
        this.profileRequirements.add(requirement);
        this.sortProfilesRequirements();
    }

    protected void sortProfilesRequirements() {
        Collections.sort(this.profileRequirements);
    }

    public void removeEmptyRequirements() {
        Iterator<ProfileRequirements> iterator = this.profileRequirements.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().checkIsEmpty()) continue;
            iterator.remove();
        }
    }

    public boolean hasMinimumInstances(String profileId) {
        ProfileRequirements profileRequirement = this.findProfileRequirements(profileId);
        if (profileRequirement != null) {
            return profileRequirement.hasMinimumInstances();
        }
        return false;
    }

    public SshHostConfiguration sshHost(String hostName) {
        List<SshHostConfiguration> hosts;
        SshConfiguration config = this.getSshConfiguration();
        if (config == null) {
            config = new SshConfiguration();
            this.setSshConfiguration(config);
        }
        if ((hosts = config.getHosts()) == null) {
            hosts = new ArrayList<SshHostConfiguration>();
            config.setHosts(hosts);
        }
        return config.host(hostName);
    }

    public ProfileRequirements profile(String profileId) {
        return this.getOrCreateProfileRequirement(profileId);
    }

    public SshConfiguration sshConfiguration() {
        SshConfiguration answer = this.getSshConfiguration();
        if (answer == null) {
            answer = new SshConfiguration();
            this.setSshConfiguration(answer);
        }
        return answer;
    }
}

