/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.commands.support;

import io.fabric8.agent.commands.ProfileWatcher;
import io.fabric8.agent.commands.support.ProfileVersionKey;
import io.fabric8.agent.commands.support.Utils;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.DownloadManagers;
import io.fabric8.agent.mvn.DictionaryPropertyResolver;
import io.fabric8.agent.mvn.MavenConfiguration;
import io.fabric8.agent.mvn.MavenConfigurationImpl;
import io.fabric8.agent.mvn.MavenRepositoryURL;
import io.fabric8.agent.mvn.Parser;
import io.fabric8.agent.mvn.PropertyResolver;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Profiles;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.common.util.Closeables;
import io.fabric8.deployer.JavaContainers;
import io.fabric8.internal.Objects;
import io.fabric8.service.child.ChildContainers;
import io.fabric8.utils.Base64Encoder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=false)
@Service(value={ProfileWatcher.class})
public class ProfileWatcherImpl
extends AbstractComponent
implements ProfileWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(ProfileWatcherImpl.class);
    private static final String WATCHED_URL_FILE = "watched-urls.properties";
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configurationAdmin = new ValidatingReference();
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    private AtomicBoolean running = new AtomicBoolean(false);
    private long interval = 1000L;
    private List<String> watchURLs = new CopyOnWriteArrayList<String>();
    private AtomicInteger counter = new AtomicInteger(0);
    private Map<ProfileVersionKey, Map<String, Parser>> profileArtifacts = null;
    private Runnable fabricConfigureChangeRunnable = new Runnable(){

        @Override
        public void run() {
            LOG.debug("Fabric configuration changed so refreshing profile watcher");
            ProfileWatcherImpl.this.counter.incrementAndGet();
        }
    };
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private boolean upload;
    private Set<String> missingChecksums = new HashSet<String>();

    @Activate
    void activate(BundleContext bundleContext) {
        this.start();
        this.activateComponent();
        this.load(bundleContext);
    }

    @Deactivate
    void deactivate(BundleContext bundleContext) {
        this.save(bundleContext);
        this.stop();
        this.deactivateComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(BundleContext bundleContext) {
        File file = bundleContext.getDataFile(WATCHED_URL_FILE);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file));
            for (String url : this.watchURLs) {
                bw.write(url);
                bw.newLine();
            }
        }
        catch (Exception ex) {
            try {
                LOG.error("Error while saving watched URLs", (Throwable)ex);
            }
            catch (Throwable throwable) {
                Closeables.closeQuitely(bw);
                throw throwable;
            }
            Closeables.closeQuitely((Closeable)bw);
        }
        Closeables.closeQuitely((Closeable)bw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(BundleContext bundleContext) {
        File file = bundleContext.getDataFile(WATCHED_URL_FILE);
        if (file.exists()) {
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new FileReader(file));
                while ((line = br.readLine()) != null) {
                    this.add(line);
                }
            }
            catch (Exception ex) {
                try {
                    LOG.error("Error while loading watched URLs", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuitely(br);
                    throw throwable;
                }
                Closeables.closeQuitely((Closeable)br);
            }
            Closeables.closeQuitely((Closeable)br);
        }
    }

    @Override
    public void run() {
        this.assertValid();
        LOG.debug("Profile watcher thread started");
        int oldCounter = -1;
        SortedSet<String> oldActiveProfiles = null;
        HashMap<File, Long> localChecksums = new HashMap<File, Long>();
        HashMap<File, Long> localModified = new HashMap<File, Long>();
        HashSet<Profile> refreshProfiles = new HashSet<Profile>();
        ProfileService profileService = (ProfileService)((FabricService)this.fabricService.get()).adapt(ProfileService.class);
        while (this.running.get() && this.watchURLs.size() > 0) {
            SortedSet<String> currentActiveProfiles = this.getCurrentActiveProfileVersions();
            if (this.profileArtifacts == null || oldCounter != this.counter.get() || oldActiveProfiles == null || !oldActiveProfiles.equals(currentActiveProfiles)) {
                oldCounter = this.counter.get();
                oldActiveProfiles = currentActiveProfiles;
                try {
                    LOG.debug("Reloading the currently active profile artifacts");
                    this.profileArtifacts = this.findProfileArifacts();
                }
                catch (Exception e) {
                    LOG.error("Failed to get profiles artifacts: " + e, (Throwable)e);
                }
            }
            for (Profile profile : refreshProfiles) {
                LOG.info("Refreshing profile: " + profile);
                Profiles.refreshProfile((FabricService)((FabricService)this.fabricService.get()), (Profile)profile);
            }
            refreshProfiles.clear();
            if (this.profileArtifacts != null) {
                File localRepository = this.getLocalRepository();
                Set<Map.Entry<ProfileVersionKey, Map<String, Parser>>> entries = this.profileArtifacts.entrySet();
                for (Map.Entry<ProfileVersionKey, Map<String, Parser>> entry : entries) {
                    ProfileVersionKey key = entry.getKey();
                    Map<String, Parser> artifactMap = entry.getValue();
                    Profile profile = key.getProfile();
                    Properties checksums = Utils.findProfileChecksums((FabricService)this.fabricService.get(), profile);
                    if (checksums == null) continue;
                    Set<Map.Entry<String, Parser>> artifactMapEntries = artifactMap.entrySet();
                    for (Map.Entry<String, Parser> artifactMapEntry : artifactMapEntries) {
                        String location = artifactMapEntry.getKey();
                        Parser parser = artifactMapEntry.getValue();
                        if (Utils.isSnapshot(parser) || this.wildCardMatch(location)) {
                            Long localChecksum;
                            Object value = checksums.get(location);
                            if (value == null) {
                                value = checksums.get(JavaContainers.removeUriPrefixBeforeMaven((String)location));
                            }
                            Long checksum = null;
                            if (value instanceof Number) {
                                checksum = ((Number)value).longValue();
                            } else if (value instanceof String) {
                                checksum = Long.parseLong((String)value);
                            }
                            if (checksum == null) {
                                if (!this.missingChecksums.add(location)) continue;
                                LOG.warn("Could not find checksum for location " + location);
                                continue;
                            }
                            File file = new File(localRepository.getPath() + File.separator + parser.getArtifactPath());
                            if (!file.exists()) {
                                LOG.info("Ignoring file " + file.getPath() + " as it does not exist");
                                continue;
                            }
                            Long oldModfied = (Long)localModified.get(file);
                            long modified = file.lastModified();
                            if (oldModfied != null && modified == oldModfied) continue;
                            localModified.put(file, modified);
                            Long fileChecksum = Utils.getFileChecksum(file);
                            if (fileChecksum == null || fileChecksum.equals(checksum) || (localChecksum = (Long)localChecksums.get(file)) != null && localChecksum.equals(fileChecksum)) continue;
                            localChecksums.put(file, fileChecksum);
                            LOG.info("Checksums don't match for " + location + ", container: " + checksum + " and local file: " + fileChecksum);
                            if (this.isUpload()) {
                                this.uploadFile(location, parser, file);
                            }
                            refreshProfiles.add(profile);
                            continue;
                        }
                        LOG.info("Ignoring " + location);
                    }
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException ex) {
                this.running.set(false);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Profile watcher thread stopped");
        }
    }

    @Override
    public Map<ProfileVersionKey, Map<String, Parser>> getProfileArtifacts() {
        if (this.profileArtifacts == null) {
            return Collections.EMPTY_MAP;
        }
        return this.profileArtifacts;
    }

    protected void uploadFile(String bundleUrl, Parser parser, File fileToUpload) {
        URL url;
        String user = ((FabricService)this.fabricService.get()).getZooKeeperUser();
        String password = ((FabricService)this.fabricService.get()).getZookeeperPassword();
        URI uploadUri = ((FabricService)this.fabricService.get()).getMavenRepoUploadURI();
        URI artifactUri = uploadUri.resolve(parser.getArtifactPath());
        try {
            url = artifactUri.toURL();
        }
        catch (MalformedURLException e) {
            LOG.warn("Failed to parse URI " + artifactUri + ". " + e, (Throwable)e);
            return;
        }
        if (fileToUpload == null) {
            return;
        }
        if (!fileToUpload.exists() || !fileToUpload.isFile()) {
            LOG.warn("Artifact file does not exist! " + fileToUpload.getAbsolutePath());
            return;
        }
        LOG.info("Uploading " + fileToUpload.getPath() + " to fabric8 maven repo: " + url + " as user: " + user);
        try {
            int code;
            FileChannel in = new FileInputStream(fileToUpload).getChannel();
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestProperty("Authorization", "Basic " + Base64Encoder.encode(user + ":" + password));
            WritableByteChannel out = Channels.newChannel(connection.getOutputStream());
            in.transferTo(0L, fileToUpload.length(), out);
            if (connection instanceof HttpURLConnection && ((code = ((HttpURLConnection)connection).getResponseCode()) < 200 || code >= 300)) {
                LOG.warn(String.format("Got response code %s while uploading %s to fabric8 maven repo: %s", code, fileToUpload.getPath(), url));
                return;
            }
            LOG.info("Uploaded  " + fileToUpload.getPath() + " to fabric8 maven repo: " + url);
        }
        catch (Exception e) {
            LOG.error("Failed to upload " + fileToUpload.getPath() + " to fabric8 maven repo: " + url + ". " + e, (Throwable)e);
        }
    }

    @Override
    public void add(String url) {
        boolean shouldStart;
        this.assertValid();
        boolean bl = shouldStart = this.running.get() && this.watchURLs.size() == 0;
        if (!this.watchURLs.contains(url)) {
            this.watchURLs.add(url);
            this.counter.incrementAndGet();
        }
        if (shouldStart) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    @Override
    public void remove(String url) {
        this.assertValid();
        this.watchURLs.remove(url);
        this.counter.incrementAndGet();
    }

    protected SortedSet<String> getCurrentActiveProfileVersions() {
        Container[] containers;
        TreeSet<String> answer = new TreeSet<String>();
        for (Container container : containers = ((FabricService)this.fabricService.get()).getContainers()) {
            Profile[] profiles;
            container.getProvisionList();
            for (Profile profile : profiles = container.getProfiles()) {
                String id = profile.getId();
                String version = profile.getVersion();
                answer.add(id + "/" + version);
            }
        }
        return answer;
    }

    private Map<ProfileVersionKey, Map<String, Parser>> findProfileArifacts() throws Exception {
        Container[] containers;
        HashMap<ProfileVersionKey, Map<String, Parser>> profileArtifacts = new HashMap<ProfileVersionKey, Map<String, Parser>>();
        ProfileService profileService = (ProfileService)((FabricService)this.fabricService.get()).adapt(ProfileService.class);
        DownloadManager downloadManager = DownloadManagers.createDownloadManager((FabricService)((FabricService)this.fabricService.get()), (ExecutorService)this.executorService);
        for (Container container : containers = ((FabricService)this.fabricService.get()).getContainers()) {
            Profile[] profiles = container.getProfiles();
            boolean javaOrProcessContainer = ChildContainers.isJavaOrProcessContainer((FabricService)((FabricService)this.fabricService.get()), (Container)container);
            for (Profile profile : profiles) {
                Profile overlay = profileService.getOverlayProfile(profile);
                ProfileVersionKey key = new ProfileVersionKey(profile);
                Map artifacts = null;
                if (javaOrProcessContainer) {
                    List<Profile> singletonList = Collections.singletonList(profile);
                    artifacts = JavaContainers.getJavaContainerArtifacts((FabricService)((FabricService)this.fabricService.get()), singletonList, (ExecutorService)this.executorService);
                } else {
                    artifacts = AgentUtils.getProfileArtifacts((FabricService)((FabricService)this.fabricService.get()), (DownloadManager)downloadManager, (Profile)overlay);
                }
                if (artifacts == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Profile " + profile.getId() + " maps to artefacts: " + artifacts.keySet());
                }
                profileArtifacts.put(key, artifacts);
            }
        }
        return profileArtifacts;
    }

    public File getLocalRepository() {
        MavenRepositoryURL localRepositoryURL;
        this.assertValid();
        MavenConfiguration configuration = this.retrieveMavenConfiguration();
        if (configuration != null && (localRepositoryURL = configuration.getLocalRepository()) != null) {
            return localRepositoryURL.getFile().getAbsoluteFile();
        }
        String localRepo = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository";
        return new File(localRepo).getAbsoluteFile();
    }

    protected MavenConfiguration retrieveMavenConfiguration() {
        MavenConfigurationImpl mavenConfiguration = null;
        try {
            Dictionary dictonary;
            Configuration configuration = ((ConfigurationAdmin)this.configurationAdmin.get()).getConfiguration("org.ops4j.pax.url.mvn");
            if (configuration != null && (dictonary = configuration.getProperties()) != null) {
                DictionaryPropertyResolver resolver = new DictionaryPropertyResolver(dictonary);
                mavenConfiguration = new MavenConfigurationImpl((PropertyResolver)resolver, "org.ops4j.pax.url.mvn");
            }
        }
        catch (IOException e) {
            LOG.error("Error retrieving maven configuration", (Throwable)e);
        }
        return mavenConfiguration;
    }

    @Override
    public boolean wildCardMatch(String text) {
        for (String watchURL : this.watchURLs) {
            if (!this.wildCardMatch(text, watchURL)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean wildCardMatch(String text, String pattern) {
        String[] cards;
        this.assertValid();
        for (String card : cards = pattern.split("\\*")) {
            int idx = text.indexOf(card);
            if (idx == -1) {
                return false;
            }
            text = text.substring(idx + card.length());
        }
        return true;
    }

    @Override
    public void start() {
        this.missingChecksums.clear();
        Objects.notNull(this.fabricService, (String)"fabricService");
        ((FabricService)this.fabricService.get()).trackConfiguration(this.fabricConfigureChangeRunnable);
        if (this.running.compareAndSet(false, true) && this.watchURLs.size() > 0) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    @Override
    public void stop() {
        this.missingChecksums.clear();
        if (this.fabricService != null) {
            ((FabricService)this.fabricService.get()).untrackConfiguration(this.fabricConfigureChangeRunnable);
        }
        this.running.set(false);
    }

    @Override
    public List<String> getWatchURLs() {
        return this.watchURLs;
    }

    public void setWatchURLs(List<String> watchURLs) {
        this.watchURLs = watchURLs;
    }

    public long getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(long interval) {
        this.interval = interval;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public boolean isUpload() {
        return this.upload;
    }

    @Override
    public void setUpload(boolean upload) {
        this.upload = upload;
    }

    void bindConfigurationAdmin(ConfigurationAdmin service) {
        this.configurationAdmin.bind((Object)service);
    }

    void unbindConfigurationAdmin(ConfigurationAdmin service) {
        this.configurationAdmin.unbind((Object)service);
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }
}

