/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.commands.support;

import io.fabric8.agent.mvn.Parser;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.common.util.ChecksumUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);

    public static boolean isSnapshot(Parser parser) {
        String version = parser.getVersion();
        return version != null && version.contains("SNAPSHOT");
    }

    public static Long getFileChecksum(File file) {
        try {
            return ChecksumUtils.checksum((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            LOG.warn("Failed to get checksum of file: " + file.getAbsolutePath() + ". " + e, (Throwable)e);
            return null;
        }
    }

    public static Properties findProfileChecksums(FabricService fabricService, Profile profile) {
        String profileId;
        Properties checksums = null;
        String versionId = profile.getVersion();
        Container[] containers = fabricService.getAssociatedContainers(versionId, profileId = profile.getId());
        if (containers != null) {
            Container container;
            Container[] arr$ = containers;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (checksums = (container = arr$[i$]).getProvisionChecksums()) == null; ++i$) {
            }
        }
        return checksums;
    }
}

