/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.commands.metadata;

import io.fabric8.agent.commands.metadata.MetadataHandler;
import io.fabric8.agent.commands.metadata.ProfileMetadataMXBean;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.DownloadManagers;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileService;
import io.fabric8.api.jmx.MetaTypeAttributeDTO;
import io.fabric8.api.jmx.MetaTypeObjectDTO;
import io.fabric8.api.jmx.MetaTypeObjectSummaryDTO;
import io.fabric8.api.jmx.MetaTypeSummaryDTO;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.common.util.JMXUtils;
import io.fabric8.common.util.Objects;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.felix.metatype.AD;
import org.apache.felix.metatype.Designate;
import org.apache.felix.metatype.MetaData;
import org.apache.felix.metatype.MetaDataReader;
import org.apache.felix.metatype.OCD;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.agent.commands.metadata.ProfileMetadata", label="Fabric8 Profile Metadata Service", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
public class ProfileMetadata
extends AbstractComponent
implements ProfileMetadataMXBean {
    protected static String PROPERTIES_SUFFIX = ".properties";
    protected static String XML_SUFFIX = ".xml";
    private static final Logger LOG = LoggerFactory.getLogger(ProfileMetadata.class);
    private static ObjectName OBJECT_NAME;
    @Property(name="metaTypeFolder", value={"${runtime.home}/metatype"}, label="Metatype Directory", description="Directory containing the MetaType metadata files")
    private File metaTypeFolder;
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=MBeanServer.class, bind="bindMBeanServer", unbind="unbindMBeanServer")
    private MBeanServer mbeanServer;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        this.updateConfiguration(configuration);
        this.activateComponent();
        if (this.mbeanServer != null) {
            StandardMBean mbean = new StandardMBean(this, ProfileMetadataMXBean.class);
            JMXUtils.registerMBean((Object)mbean, (MBeanServer)this.mbeanServer, (ObjectName)OBJECT_NAME);
        }
    }

    @Modified
    void modified(Map<String, ?> configuration) throws Exception {
        this.updateConfiguration(configuration);
    }

    private void updateConfiguration(Map<String, ?> configuration) throws Exception {
        this.configurer.configure(configuration, (Object)this, new String[0]);
    }

    @Deactivate
    void deactivate() throws Exception {
        this.deactivateComponent();
        if (this.mbeanServer != null) {
            JMXUtils.unregisterMBean((MBeanServer)this.mbeanServer, (ObjectName)OBJECT_NAME);
        }
    }

    @Override
    public MetaTypeSummaryDTO metaTypeSummary(String versionId, String profileId) throws Exception {
        final MetaTypeSummaryDTO answer = new MetaTypeSummaryDTO();
        MetadataHandler handler = new MetadataHandler(){

            @Override
            public void invoke(MetaData metadata, Properties resources) {
                ProfileMetadata.this.addMetaData(answer, metadata, resources);
            }
        };
        this.findMetadataForProfile(versionId, profileId, handler);
        return answer;
    }

    protected void findMetadataForProfile(String versionId, String profileId, MetadataHandler handler) throws Exception {
        FabricService service = (FabricService)this.fabricService.get();
        Objects.notNull((Object)service, (String)"FabricService");
        ProfileService profileService = (ProfileService)service.adapt(ProfileService.class);
        Objects.notNull((Object)profileService, (String)"ProfileService");
        DownloadManager downloadManager = DownloadManagers.createDownloadManager((FabricService)service, (ExecutorService)this.executorService);
        Objects.notNull((Object)downloadManager, (String)"DownloadManager");
        Profile immediateProfile = profileService.getProfile(versionId, profileId);
        Objects.notNull((Object)immediateProfile, (String)("Profile for versionId: " + versionId + ", profileId: " + profileId));
        Profile profile = profileService.getOverlayProfile(immediateProfile);
        HashSet<String> pids = new HashSet<String>();
        Map fileMap = AgentUtils.downloadProfileArtifacts((FabricService)service, (DownloadManager)downloadManager, (Profile)profile);
        Set entries = fileMap.entrySet();
        for (Map.Entry entry : entries) {
            String uri = (String)entry.getKey();
            File file = (File)entry.getValue();
            if (!file.exists() || !file.isFile()) {
                LOG.warn("File " + file + " is not an existing file for " + uri + ". Ignoring");
                continue;
            }
            this.addMetaTypeInformation(handler, uri, file);
            pids.add(uri);
        }
        if (this.metaTypeFolder != null && this.metaTypeFolder.exists() && this.metaTypeFolder.isDirectory()) {
            Set configurationFileNames = profile.getConfigurationFileNames();
            for (String configName : configurationFileNames) {
                if (!configName.endsWith(PROPERTIES_SUFFIX) || configName.indexOf(47) >= 0) continue;
                String pid = configName.substring(0, configName.length() - PROPERTIES_SUFFIX.length());
                this.addMetaTypeInformation(pids, handler, pid);
                String factoryPid = this.getFactoryPid(pid);
                this.addMetaTypeInformation(pids, handler, factoryPid);
            }
        }
    }

    private void addMetaTypeInformation(Set<String> pids, MetadataHandler handler, String pid) throws IOException {
        if (pid != null && pid.length() > 0 && pids.add(pid)) {
            File pidFolder = new File(this.metaTypeFolder, pid);
            File xmlFile = new File(pidFolder, "metatype.xml");
            File propertiesFile = new File(pidFolder, "metatype.properties");
            this.addMetaTypeInformation(handler, pid, xmlFile, propertiesFile);
        }
    }

    protected String getFactoryPid(String pid) {
        int idx = pid.indexOf(45);
        if (idx > 0) {
            return pid.substring(0, idx);
        }
        return null;
    }

    @Override
    public MetaTypeObjectDTO getPidMetaTypeObject(String versionId, String profileId, final String pid) throws Exception {
        final AtomicReference<Object> answer = new AtomicReference<Object>(null);
        MetadataHandler handler = new MetadataHandler(){

            @Override
            public void invoke(MetaData metadata, Properties resources) {
                Map map = metadata.getDesignates();
                Map objects = metadata.getObjectClassDefinitions();
                Set entries = map.entrySet();
                for (Map.Entry entry : entries) {
                    String aPid = (String)entry.getKey();
                    Object value = objects.get(aPid);
                    if (!Objects.equal((Object)pid, (Object)aPid) || !(value instanceof OCD)) continue;
                    OCD ocd = (OCD)value;
                    answer.set(ProfileMetadata.createMetaTypeObjectDTO(resources, ocd));
                }
            }
        };
        this.findMetadataForProfile(versionId, profileId, handler);
        return answer.get();
    }

    protected static MetaTypeObjectDTO createMetaTypeObjectDTO(Properties resources, OCD ocd) {
        MetaTypeObjectDTO answer = new MetaTypeObjectDTO();
        answer.setId(ocd.getID());
        answer.setName(ProfileMetadata.localize(resources, ocd.getName()));
        answer.setDescription(ProfileMetadata.localize(resources, ocd.getDescription()));
        ArrayList<MetaTypeAttributeDTO> attributeList = new ArrayList<MetaTypeAttributeDTO>();
        Map attributes = ocd.getAttributeDefinitions();
        if (attributes != null) {
            Set entries = attributes.entrySet();
            for (Map.Entry entry : entries) {
                AD ad;
                MetaTypeAttributeDTO attributeDTO;
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof AD) || (attributeDTO = ProfileMetadata.createMetaTypeAttributeDTO(resources, ocd, name, ad = (AD)value)) == null) continue;
                attributeList.add(attributeDTO);
            }
        }
        answer.setAttributes(attributeList);
        return answer;
    }

    protected static MetaTypeAttributeDTO createMetaTypeAttributeDTO(Properties resources, OCD ocd, String name, AD ad) {
        MetaTypeAttributeDTO answer = new MetaTypeAttributeDTO();
        answer.setId(ad.getID());
        answer.setName(ProfileMetadata.localize(resources, ad.getName()));
        answer.setDescription(ProfileMetadata.localize(resources, ad.getDescription()));
        answer.setCardinality(ad.getCardinality());
        answer.setDefaultValue(ad.getDefaultValue());
        answer.setOptionLabels(ad.getOptionLabels());
        answer.setOptionValues(ad.getOptionValues());
        answer.setRequired(ad.isRequired());
        answer.setTypeName(MetaTypeAttributeDTO.typeName((int)ad.getType()));
        return answer;
    }

    protected void addMetaTypeInformation(MetadataHandler handler, String pid, File xmlFile, File propertiesFile) throws IOException {
        MetaData metadata;
        if (!xmlFile.exists()) {
            LOG.info("Warning! " + xmlFile + " does not exist so no OSGi MetaType metadata");
            metadata = new MetaData();
            Designate designate = new Designate();
            designate.setPid(pid);
            metadata.addDesignate(designate);
            OCD ocd = new OCD();
            ocd.setId(pid);
            metadata.addObjectClassDefinition(ocd);
        } else {
            MetaDataReader reader = new MetaDataReader();
            metadata = reader.parse((InputStream)new FileInputStream(xmlFile));
        }
        Properties properties = new Properties();
        if (propertiesFile.exists() && propertiesFile.isFile()) {
            properties.load(new FileInputStream(propertiesFile));
        }
        handler.invoke(metadata, properties);
    }

    protected void addMetaTypeInformation(MetadataHandler handler, String uri, File file) throws IOException {
        MetaData metadata;
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> entries = jarFile.entries();
        HashMap<String, MetaData> metadataMap = new HashMap<String, MetaData>();
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith("OSGI-INF/metatype/")) continue;
            if (name.endsWith(XML_SUFFIX)) {
                MetaDataReader reader = new MetaDataReader();
                InputStream in = jarFile.getInputStream(entry);
                if (in == null || (metadata = reader.parse(in)) == null) continue;
                String pid = name.substring(0, name.length() - XML_SUFFIX.length());
                metadataMap.put(pid, metadata);
                continue;
            }
            if (!name.endsWith(PROPERTIES_SUFFIX)) continue;
            String pid = name.substring(0, name.length() - PROPERTIES_SUFFIX.length());
            Properties properties = new Properties();
            InputStream in = jarFile.getInputStream(entry);
            if (in == null) continue;
            properties.load(in);
            propertiesMap.put(pid, properties);
        }
        Set metadataEntries = metadataMap.entrySet();
        for (Map.Entry metadataEntry : metadataEntries) {
            String pid = (String)metadataEntry.getKey();
            metadata = (MetaData)metadataEntry.getValue();
            Properties properties = (Properties)propertiesMap.get(pid);
            if (properties == null) {
                properties = new Properties();
            }
            handler.invoke(metadata, properties);
        }
    }

    protected void addMetaData(MetaTypeSummaryDTO summary, MetaData metadata, Properties resources) {
        Map map = metadata.getDesignates();
        Map objects = metadata.getObjectClassDefinitions();
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            String pid = (String)entry.getKey();
            Object value = objects.get(pid);
            if (!(value instanceof OCD)) continue;
            OCD ocd = (OCD)value;
            MetaTypeObjectSummaryDTO object = summary.getOrCreateMetaTypeSummaryDTO(pid);
            object.setId(pid);
            object.setName(ProfileMetadata.localize(resources, ocd.getName()));
            object.setDescription(ProfileMetadata.localize(resources, ocd.getDescription()));
        }
    }

    protected static String localize(Properties resources, String string) {
        if (string != null && string.startsWith("%") && resources != null) {
            string = string.substring(1);
            try {
                return resources.getProperty(string);
            }
            catch (Exception e) {
                LOG.warn("localize: Failed getting resources '" + string + "'", (Throwable)e);
            }
        }
        return string;
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    void unbindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = null;
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("io.fabric8:type=ProfileMetadata");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

