/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.boot.commands.support.ParameterCompleter;
import io.fabric8.boot.commands.support.ProfileCompleter;
import io.fabric8.boot.commands.support.VersionCompleter;
import io.fabric8.commands.MQCreateAction;
import io.fabric8.commands.support.BrokerKindCompleter;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.console.Completer;

@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"mq-create"})})
public class MQCreate
extends AbstractCommandComponent {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "mq-create";
    public static final String DESCRIPTION = "Create a new broker";
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=ProfileCompleter.class, bind="bindProfileCompleter", unbind="unbindProfileCompleter")
    private ProfileCompleter profileCompleter;
    @Reference(referenceInterface=ProfileCompleter.class, bind="bindParentProfileCompleter", unbind="unbindParentProfileCompleter")
    private ProfileCompleter parentProfileCompleter;
    @Reference(referenceInterface=VersionCompleter.class, bind="bindVersionCompleter", unbind="unbindVersionCompleter")
    private VersionCompleter versionCompleter;

    @Activate
    void activate() {
        this.bindOptionalCompleter("--kind", (Completer)new BrokerKindCompleter());
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.unbindOptionalCompleter("--kind");
        this.deactivateComponent();
    }

    public Action createNewAction() {
        this.assertValid();
        return new MQCreateAction((FabricService)this.fabricService.get());
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindProfileCompleter(ProfileCompleter completer) {
        this.bindOptionalCompleter("--profile", (Completer)completer);
    }

    void unbindProfileCompleter(ProfileCompleter completer) {
        this.unbindOptionalCompleter((ParameterCompleter)completer);
    }

    void bindParentProfileCompleter(ProfileCompleter completer) {
        this.bindOptionalCompleter("--parent-profile", (Completer)completer);
    }

    void unbindParentProfileCompleter(ProfileCompleter completer) {
        this.unbindOptionalCompleter((ParameterCompleter)completer);
    }

    void bindVersionCompleter(VersionCompleter completer) {
        this.bindOptionalCompleter("--version", (Completer)completer);
    }

    void unbindVersionCompleter(VersionCompleter completer) {
        this.unbindOptionalCompleter((ParameterCompleter)completer);
    }
}

