/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.Version;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CompleterValues;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="profile-export", scope="fabric", description="Exports all matching profile folders into the given output zip file.")
public class ProfileExportAction
extends AbstractAction {
    @Option(name="--version", description="The profile version to export profiles from. Defaults to the current version if none specified.")
    private String version;
    @Option(name="-t", aliases={"--threads"}, description="The number of threads to use for the download manager. Defaults to 1")
    private int threadPoolSize;
    @Argument(index=0, required=true, name="outputZipFileName", description="The output file name of the generated ZIP of the profiles")
    @CompleterValues(index=0)
    private File outputZipFileName;
    @Argument(index=1, required=false, name="wildcard", description="The file wildcard used to match the profile folders. e.g. 'examples/*'. If no wildcard is specified all profiles will be exported")
    @CompleterValues(index=1)
    private String wildcard;
    private final FabricService fabricService;
    private ExecutorService executorService;

    ProfileExportAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        Version ver;
        Version version = ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
        if (ver == null) {
            if (this.version != null) {
                System.out.println("version " + this.version + " does not exist!");
            } else {
                System.out.println("No default version available!");
            }
            return null;
        }
        if (this.executorService == null) {
            this.executorService = this.threadPoolSize > 1 ? Executors.newFixedThreadPool(this.threadPoolSize) : Executors.newSingleThreadExecutor();
        }
        this.fabricService.getDataStore().exportProfiles(ver.getId(), this.outputZipFileName.getAbsolutePath(), this.wildcard);
        System.out.println("Exported profiles to " + this.outputZipFileName.getCanonicalPath());
        return null;
    }
}

