/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.Version;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="version-set-default", scope="fabric", description="Set the new default version (must be one of the existing versions)", detailedDescription="classpath:versionSetDefault.txt")
public class VersionSetDefaultAction
extends AbstractAction {
    @Argument(index=0, description="Version number to use as new default version.", required=true)
    private String versionName;
    private final FabricService fabricService;

    VersionSetDefaultAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    protected Object doExecute() throws Exception {
        Version version = this.getFabricService().getVersion(this.versionName);
        if (version == null) {
            throw new IllegalArgumentException("Cannot find version: " + this.versionName);
        }
        Version currentDefault = this.getFabricService().getDefaultVersion();
        if (version.compareTo((Object)currentDefault) == 0) {
            System.out.println("Version " + version + " is already default version.");
        } else {
            this.getFabricService().setDefaultVersion(version);
            System.out.println("Changed default version to " + version);
        }
        return null;
    }
}

