/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.boot.commands.support.ProfileCompleter;
import io.fabric8.boot.commands.support.VersionCompleter;
import io.fabric8.commands.ProfileEditAction;
import io.fabric8.commands.support.BundleLocationCompleter;
import io.fabric8.commands.support.FeaturesCompleter;
import io.fabric8.commands.support.FeaturesUrlCompleter;
import io.fabric8.commands.support.PidCompleter;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.shell.console.Completer;
import org.jledit.EditorFactory;
import org.osgi.service.cm.ConfigurationAdmin;

@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"profile-edit"})})
public final class ProfileEdit
extends AbstractCommandComponent {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "profile-edit";
    public static final String DESCRIPTION = "Edits the specified version of the specified profile (where the version defaults to the current default version)";
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configurationAdmin = new ValidatingReference();
    @Reference(referenceInterface=EditorFactory.class)
    private final ValidatingReference<EditorFactory> editorFactory = new ValidatingReference();
    @Reference(referenceInterface=FeaturesService.class)
    private final ValidatingReference<FeaturesService> featuresService = new ValidatingReference();
    @Reference(referenceInterface=ProfileCompleter.class, bind="bindProfileCompleter", unbind="unbindProfileCompleter")
    private ProfileCompleter profileCompleter;
    @Reference(referenceInterface=VersionCompleter.class, bind="bindVersionCompleter", unbind="unbindVersionCompleter")
    private VersionCompleter versionCompleter;
    @Reference(referenceInterface=BundleLocationCompleter.class, bind="bindBundleLocationCompleter", unbind="unbindBundleLocationCompleter")
    private BundleLocationCompleter bundleLocationCompleter;
    @Reference(referenceInterface=FeaturesCompleter.class, bind="bindFeaturesCompleter", unbind="unbindFeaturesCompleter")
    private FeaturesCompleter featuresCompleter;
    @Reference(referenceInterface=FeaturesUrlCompleter.class, bind="bindFeaturesUrlCompleter", unbind="unbindFeaturesUrlCompleter")
    private FeaturesUrlCompleter featuresUrlCompleter;
    @Reference(referenceInterface=PidCompleter.class, bind="bindPidCompleter", unbind="unbindPidCompleter")
    private PidCompleter pidCompleter;

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public Action createNewAction() {
        this.assertValid();
        return new ProfileEditAction((FabricService)this.fabricService.get(), (ConfigurationAdmin)this.configurationAdmin.get(), (EditorFactory)this.editorFactory.get());
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin.bind((Object)configurationAdmin);
    }

    void unbindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin.unbind((Object)configurationAdmin);
    }

    void bindEditorFactory(EditorFactory editorFactory) {
        this.editorFactory.bind((Object)editorFactory);
    }

    void unbindEditorFactory(EditorFactory editorFactory) {
        this.editorFactory.unbind((Object)editorFactory);
    }

    void bindFeaturesService(FeaturesService featuresService) {
        this.featuresService.bind((Object)featuresService);
    }

    void unbindFeaturesService(FeaturesService featuresService) {
        this.featuresService.unbind((Object)featuresService);
    }

    void bindProfileCompleter(ProfileCompleter completer) {
        this.bindCompleter((Completer)completer);
    }

    void unbindProfileCompleter(ProfileCompleter completer) {
        this.unbindCompleter((Completer)completer);
    }

    void bindVersionCompleter(VersionCompleter completer) {
        this.bindCompleter((Completer)completer);
    }

    void unbindVersionCompleter(VersionCompleter completer) {
        this.unbindCompleter((Completer)completer);
    }

    void bindBundleLocationCompleter(BundleLocationCompleter completer) {
        this.bindOptionalCompleter("--bundles", completer);
    }

    void unbindBundleLocationCompleter(BundleLocationCompleter completer) {
        this.unbindOptionalCompleter("--bundles");
    }

    void bindFeaturesCompleter(FeaturesCompleter completer) {
        this.bindOptionalCompleter("--features", completer);
    }

    void unbindFeaturesCompleter(FeaturesCompleter completer) {
        this.unbindOptionalCompleter("--features");
    }

    void bindFeaturesUrlCompleter(FeaturesUrlCompleter completer) {
        this.bindOptionalCompleter("--repositories", completer);
    }

    void unbindFeaturesUrlCompleter(FeaturesUrlCompleter completer) {
        this.unbindOptionalCompleter("--repositories");
    }

    void bindPidCompleter(PidCompleter completer) {
        this.bindOptionalCompleter("--pid", completer);
    }

    void unbindPidCompleter(PidCompleter completer) {
        this.unbindOptionalCompleter("--pid");
    }
}

