/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.common.util.Strings;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="crypt-algorithm-set", scope="fabric", description="Sets the encryption algorithm.")
public class EncryptionAlgorithmSetAction
extends AbstractAction {
    @Argument(index=0, name="algorithm", description="The algorithm to set for encryption.")
    private String newAlgorithm;
    private final CuratorFramework curator;

    EncryptionAlgorithmSetAction(CuratorFramework curator) {
        this.curator = curator;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    protected Object doExecute() throws Exception {
        if (Strings.isNotBlank((String)this.newAlgorithm)) {
            ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.AUTHENTICATION_CRYPT_ALGORITHM.getPath(new String[0]), (String)this.newAlgorithm);
        }
        return null;
    }
}

