/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.Version;
import io.fabric8.api.scr.support.Strings;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CompleterValues;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="profile-import", scope="fabric", description="Downloads the given profile zip(s) and installs them into either the current version or a newly created version.")
public class ProfileImportAction
extends AbstractAction {
    @Option(name="--version", description="The profile version to import the profiles into. Defaults to the current default version if none specified.")
    private String version;
    @Option(name="-n", aliases={"--new"}, description="Forces a new version to be created if no version option is specified")
    private boolean newVersion;
    @Option(name="-t", aliases={"--threads"}, description="The number of threads to use for the download manager. Defaults to 1")
    private int threadPoolSize;
    @Argument(index=0, required=true, multiValued=true, name="profileUrls", description="The URLs for one or more profile ZIP files to install; usually of the form mvn:groupId/artifactId/version/zip/profile")
    @CompleterValues(index=0)
    private List<String> profileUrls;
    private final FabricService fabricService;
    private ExecutorService executorService;

    ProfileImportAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        Version ver;
        if (!Strings.isNullOrBlank((String)this.version) || this.newVersion) {
            // empty if block
        }
        Version version = ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
        if (ver == null) {
            if (this.version != null) {
                System.out.println("version " + this.version + " does not exist!");
            } else {
                System.out.println("No default version available!");
            }
            return null;
        }
        if (this.executorService == null) {
            this.executorService = this.threadPoolSize > 1 ? Executors.newFixedThreadPool(this.threadPoolSize) : Executors.newSingleThreadExecutor();
        }
        this.fabricService.getDataStore().importProfiles(ver.getId(), this.profileUrls);
        return null;
    }
}

