/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.commands;

import io.fabric8.agent.download.ProfileDownloader;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CompleterValues;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="profile-download", scope="fabric", description="Downloads all of the bundles, features and fabs from a version or profile to a directory to make an offline maven repository.")
public class ProfileDownloadAction
extends AbstractAction {
    @Option(name="--version", description="The profile version to download. Defaults to the current default version.")
    private String version;
    @Option(name="--profile", description="The profile to download. Defaults to all profiles in the selected version.")
    private String profile;
    @Option(name="-f", aliases={"--force"}, description="Flag to allow overwriting of files already in the target directory")
    private boolean force;
    @Option(name="-t", aliases={"--threads"}, description="The number of threads to use for the download manager. Defaults to 1")
    private int threadPoolSize;
    @Argument(index=0, required=false, name="target directory", description="The directory to download files to. Defaults to the system folder")
    @CompleterValues(index=0)
    private File target;
    private final FabricService fabricService;
    private ExecutorService executorService;

    ProfileDownloadAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        Version ver;
        Version version = ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
        if (ver == null) {
            if (this.version != null) {
                System.out.println("version " + this.version + " does not exist!");
            } else {
                System.out.println("No default version available!");
            }
            return null;
        }
        if (this.target == null) {
            String karafBase = System.getProperty("karaf.base", ".");
            this.target = new File(karafBase + "/system");
        }
        this.target.mkdirs();
        if (!this.target.exists()) {
            System.out.println("Could not create the target directory " + this.target);
            return null;
        }
        if (!this.target.isDirectory()) {
            System.out.println("Target is not a directory " + this.target);
            return null;
        }
        if (this.executorService == null) {
            this.executorService = this.threadPoolSize > 1 ? Executors.newFixedThreadPool(this.threadPoolSize) : Executors.newSingleThreadExecutor();
        }
        ProfileDownloader downloader = new ProfileDownloader(this.fabricService, this.target, this.force, this.executorService);
        if (this.profile != null) {
            Profile profileObject = null;
            if (ver.hasProfile(this.profile)) {
                profileObject = ver.getProfile(this.profile);
            }
            if (profileObject == null) {
                System.out.println("Source profile " + this.profile + " not found.");
                return null;
            }
            downloader.downloadProfile(profileObject);
        } else {
            downloader.downloadVersion(ver);
        }
        List failedProfileIDs = downloader.getFailedProfileIDs();
        System.out.println("Downloaded " + downloader.getProcessedFileCount() + " file(s) to " + this.target);
        if (failedProfileIDs.size() > 0) {
            System.out.println("Failed to download these profiles: " + failedProfileIDs + ". Check the logs for details");
        }
        return null;
    }
}

