/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.ZooKeeperClusterService;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.boot.commands.support.ContainerCompleter;
import io.fabric8.commands.EnsembleAddAction;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;
import org.osgi.framework.BundleContext;

@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"ensemble-add"})})
public final class EnsembleAdd
extends AbstractCommandComponent {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "ensemble-add";
    public static final String DESCRIPTION = "Extend the current fabric ensemble by converting the specified containers into ensemble servers";
    @Reference(referenceInterface=ZooKeeperClusterService.class)
    private final ValidatingReference<ZooKeeperClusterService> clusterService = new ValidatingReference();
    @Reference(referenceInterface=ContainerCompleter.class, bind="bindContainerCompleter", unbind="unbindContainerCompleter")
    private ContainerCompleter containerCompleter;
    private BundleContext bundleContext;

    @Activate
    void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public Action createNewAction() {
        this.assertValid();
        return new EnsembleAddAction(this.bundleContext, (ZooKeeperClusterService)this.clusterService.get());
    }

    void bindClusterService(ZooKeeperClusterService clusterService) {
        this.clusterService.bind((Object)clusterService);
    }

    void unbindClusterService(ZooKeeperClusterService clusterService) {
        this.clusterService.unbind((Object)clusterService);
    }

    void bindContainerCompleter(ContainerCompleter completer) {
        this.bindCompleter(completer);
    }

    void unbindContainerCompleter(ContainerCompleter completer) {
        this.unbindCompleter(completer);
    }
}

