/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.utils.FabricValidations;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="container-add-profile", scope="fabric", description="Adds the specified profile to the container list of profiles")
public class ContainerAddProfileAction
extends AbstractAction {
    @Argument(index=0, name="container", description="The container name", required=true, multiValued=false)
    private String container;
    @Argument(index=1, name="profiles", description="The profiles to add to the container.", required=true, multiValued=true)
    private List<String> profiles;
    private final FabricService fabricService;

    ContainerAddProfileAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        FabricValidations.validateContainerName(this.container);
        FabricValidations.validateProfileNames(this.profiles);
        Container cont = FabricCommand.getContainer(this.fabricService, this.container);
        Profile[] profs = FabricCommand.getProfiles(this.fabricService, cont.getVersion(), this.profiles);
        cont.addProfiles(profs);
        return null;
    }
}

