/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricAuthenticationException;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.utils.FabricValidations;
import io.fabric8.utils.shell.ShellUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.BlueprintContainerAware;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.common.util.NoCloseInputStream;
import org.apache.sshd.common.util.NoCloseOutputStream;
import org.osgi.service.blueprint.container.BlueprintContainer;

@Command(name="container-connect", scope="fabric", description="Connect to a remote container")
public class ContainerConnect
extends FabricCommand
implements BlueprintContainerAware {
    @Option(name="-u", aliases={"--username"}, description="Remote user name", required=false, multiValued=false)
    private String username;
    @Option(name="-p", aliases={"--password"}, description="Remote user password", required=false, multiValued=false)
    private String password;
    @Argument(index=0, name="container", description="The container name", required=true, multiValued=false)
    private String container = null;
    @Argument(index=1, name="command", description="Optional command to execute", required=false, multiValued=true)
    private List<String> command;
    private BlueprintContainer blueprintContainer;
    private ClientSession sshSession;
    private String sshClientId;

    protected Object doExecute() throws Exception {
        Container found;
        String sshUrl;
        this.checkFabricAvailable();
        FabricValidations.validateContainerName(this.container);
        String cmdStr = "";
        if (this.command != null) {
            StringBuilder sb = new StringBuilder();
            for (String cmd : this.command) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(cmd);
            }
            sb.append("\n");
            cmdStr = sb.toString();
        }
        if ((sshUrl = (found = FabricCommand.getContainer(this.fabricService, this.container)).getSshUrl()) == null) {
            throw new IllegalArgumentException("Container " + this.container + " has no SSH URL.");
        }
        String[] ssh = sshUrl.split(":");
        if (ssh.length < 2) {
            throw new IllegalArgumentException("Container " + this.container + " has an invalid SSH URL '" + sshUrl + "'");
        }
        this.username = this.username != null && !this.username.isEmpty() ? this.username : ShellUtils.retrieveFabricUser(this.session);
        this.password = this.password != null ? this.password : ShellUtils.retrieveFabricUserPassword(this.session);
        try {
            this.executSshCommand(this.session, this.username, this.password, ssh[0], ssh[1], cmdStr);
        }
        catch (FabricAuthenticationException ex) {
            this.username = null;
            this.password = null;
            this.promptForSshCredentialsIfNeeded();
            this.executSshCommand(this.session, this.username, this.password, ssh[0], ssh[1], cmdStr);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executSshCommand(CommandSession session, String username, String password, String hostname, String port, String cmd) throws Exception {
        SshClient client = this.getSshClient(this.blueprintContainer, this.sshClientId);
        String agentSocket = null;
        if (this.session.get("SSH_AUTH_SOCK") != null) {
            agentSocket = this.session.get("SSH_AUTH_SOCK").toString();
            client.getProperties().put("SSH_AUTH_SOCK", agentSocket);
        }
        try {
            ConnectFuture future = client.connect(hostname, Integer.parseInt(port));
            future.await();
            this.sshSession = future.getSession();
            Object oldIgnoreInterrupts = this.session.get("karaf.ignoreInterrupts");
            this.session.put("karaf.ignoreInterrupts", (Object)Boolean.TRUE);
            try {
                ClientChannel channel;
                System.out.println("Connected");
                boolean authed = false;
                if (!authed) {
                    if (username == null) {
                        throw new FabricAuthenticationException("No username specified.");
                    }
                    this.log.debug("Prompting user for password");
                    String pwd = password != null ? password : ShellUtils.readLine(session, "Password: ", true);
                    this.sshSession.authPassword(username, pwd);
                    int ret = this.sshSession.waitFor(14, 0L);
                    if ((ret & 8) == 0) {
                        System.err.println("Password authentication failed");
                    } else {
                        authed = true;
                    }
                }
                if (!authed) {
                    throw new FabricAuthenticationException("Failed to authenticate.");
                }
                ShellUtils.storeFabricCredentials(session, username, password);
                if (cmd != null && cmd.length() > 0) {
                    channel = this.sshSession.createChannel("exec", cmd);
                    channel.setIn((InputStream)new ByteArrayInputStream(new byte[0]));
                } else {
                    channel = this.sshSession.createChannel("shell");
                    channel.setIn((InputStream)new NoCloseInputStream(System.in));
                    ((ChannelShell)channel).setPtyColumns(ShellUtils.getTermWidth(session));
                    ((ChannelShell)channel).setupSensibleDefaultPty();
                    ((ChannelShell)channel).setAgentForwarding(true);
                }
                channel.setOut((OutputStream)new NoCloseOutputStream((OutputStream)System.out));
                channel.setErr((OutputStream)new NoCloseOutputStream((OutputStream)System.err));
                channel.open();
                channel.waitFor(2, 0L);
            }
            finally {
                session.put("karaf.ignoreInterrupts", oldIgnoreInterrupts);
                this.sshSession.close(false);
            }
        }
        finally {
            client.stop();
        }
    }

    private void promptForSshCredentialsIfNeeded() throws IOException {
        if (this.username == null || this.username.isEmpty()) {
            this.log.debug("Prompting user for ssh login");
            this.username = ShellUtils.readLine(this.session, "SSH Login for " + this.container + ": ", false);
        }
        if (this.password == null) {
            this.password = ShellUtils.readLine(this.session, "SSH Password for " + this.username + "@" + this.container + ": ", true);
        }
    }

    private SshClient getSshClient(BlueprintContainer blueprintContainer, String clientId) {
        SshClient client = (SshClient)blueprintContainer.getComponentInstance(clientId);
        this.log.debug("Created client: {}", (Object)client);
        client.start();
        return client;
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        assert (blueprintContainer != null);
        this.blueprintContainer = blueprintContainer;
    }

    public void setSshClientId(String sshClientId) {
        this.sshClientId = sshClientId;
    }
}

