/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.mvn;

import io.fabric8.agent.mvn.MavenConfiguration;
import io.fabric8.agent.mvn.MavenRepositoryURL;
import io.fabric8.agent.mvn.MavenSettings;
import io.fabric8.agent.mvn.PropertyResolver;
import io.fabric8.agent.mvn.PropertyStore;
import io.fabric8.utils.NullArgumentException;
import java.io.File;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MavenConfigurationImpl
extends PropertyStore
implements MavenConfiguration {
    private static final Log LOGGER = LogFactory.getLog(MavenConfigurationImpl.class);
    private static final String REPOSITORIES_APPEND_SIGN = "+";
    private static final String REPOSITORIES_SEPARATOR = ",";
    private MavenSettings m_settings;
    private final String m_pid;
    private final PropertyResolver m_propertyResolver;

    public MavenConfigurationImpl(PropertyResolver propertyResolver, String pid) {
        NullArgumentException.validateNotNull(propertyResolver, "Property resolver");
        NullArgumentException.validateNotEmpty(pid, true, "Configuration pid");
        this.m_pid = pid;
        this.m_propertyResolver = propertyResolver;
    }

    public void setSettings(MavenSettings settings) {
        this.m_settings = settings;
    }

    @Override
    public Boolean getCertificateCheck() {
        if (!this.contains(this.m_pid + ".certificateCheck")) {
            return this.set(this.m_pid + ".certificateCheck", Boolean.valueOf(this.m_propertyResolver.get(this.m_pid + ".certificateCheck")));
        }
        return (Boolean)this.get(this.m_pid + ".certificateCheck");
    }

    @Override
    public URL getSettingsFileUrl() {
        block6: {
            String spec;
            if (!this.contains(this.m_pid + ".settings") && (spec = this.m_propertyResolver.get(this.m_pid + ".settings")) != null) {
                try {
                    return this.set(this.m_pid + ".settings", new URL(spec));
                }
                catch (MalformedURLException e) {
                    File file = new File(spec);
                    if (file.exists()) {
                        try {
                            return this.set(this.m_pid + ".settings", file.toURL());
                        }
                        catch (MalformedURLException ignore) {
                            break block6;
                        }
                    }
                    LOGGER.warn((Object)("Settings file [" + spec + "] cannot be used and will be skipped (malformed url or file does not exist)"));
                    this.set(this.m_pid + ".settings", null);
                }
            }
        }
        return (URL)this.get(this.m_pid + ".settings");
    }

    @Override
    public List<MavenRepositoryURL> getDefaultRepositories() throws MalformedURLException {
        if (!this.contains(this.m_pid + ".defaultRepositories")) {
            String defaultRepositoriesProp = this.m_propertyResolver.get(this.m_pid + ".defaultRepositories");
            ArrayList<MavenRepositoryURL> defaultRepositoriesProperty = new ArrayList<MavenRepositoryURL>();
            MavenRepositoryURL localRepository = this.getLocalRepository();
            if (defaultRepositoriesProp != null && defaultRepositoriesProp.trim().length() > 0) {
                String[] repositories;
                for (String repositoryURL : repositories = defaultRepositoriesProp.split(REPOSITORIES_SEPARATOR)) {
                    defaultRepositoriesProperty.add(new MavenRepositoryURL(repositoryURL));
                }
            }
            LOGGER.trace((Object)("Using repositories [" + defaultRepositoriesProperty + "]"));
            return this.set(this.m_pid + ".defaultRepositories", defaultRepositoriesProperty);
        }
        return (List)this.get(this.m_pid + ".defaultRepositories");
    }

    @Override
    public List<MavenRepositoryURL> getRepositories() throws MalformedURLException {
        if (!this.contains(this.m_pid + ".repositories")) {
            String settingsRepos;
            String repositoriesProp = this.m_propertyResolver.get(this.m_pid + ".repositories");
            if ((repositoriesProp == null || repositoriesProp.startsWith(REPOSITORIES_APPEND_SIGN)) && this.m_settings != null && (settingsRepos = this.m_settings.getRepositories()) != null) {
                repositoriesProp = repositoriesProp == null ? settingsRepos : repositoriesProp.substring(1) + REPOSITORIES_SEPARATOR + settingsRepos;
            }
            ArrayList<MavenRepositoryURL> repositoriesProperty = new ArrayList<MavenRepositoryURL>();
            MavenRepositoryURL localRepository = this.getLocalRepository();
            if (localRepository != null) {
                repositoriesProperty.add(localRepository);
            }
            if (repositoriesProp != null && repositoriesProp.trim().length() > 0) {
                String[] repositories;
                for (String repositoryURL : repositories = repositoriesProp.split(REPOSITORIES_SEPARATOR)) {
                    repositoriesProperty.add(new MavenRepositoryURL(repositoryURL));
                }
            }
            LOGGER.trace((Object)("Using repositories [" + repositoriesProperty + "]"));
            return this.set(this.m_pid + ".repositories", repositoriesProperty);
        }
        return (List)this.get(this.m_pid + ".repositories");
    }

    @Override
    public MavenRepositoryURL getLocalRepository() {
        if (!this.contains(this.m_pid + ".localRepository")) {
            String spec = this.m_propertyResolver.get(this.m_pid + ".localRepository");
            if (spec == null && this.m_settings != null) {
                spec = this.m_settings.getLocalRepository();
            }
            if (spec != null) {
                if (!spec.toLowerCase().contains("@snapshots")) {
                    spec = spec + "@snapshots";
                }
                try {
                    return this.set(this.m_pid + ".localRepository", new MavenRepositoryURL(spec));
                }
                catch (MalformedURLException e) {
                    try {
                        return this.set(this.m_pid + ".localRepository", new MavenRepositoryURL(new File(spec).toURI().toASCIIString()));
                    }
                    catch (MalformedURLException ignore) {
                        LOGGER.warn((Object)("Local repository [" + spec + "] cannot be used and will be skipped"));
                        return this.set(this.m_pid + ".localRepository", null);
                    }
                }
            }
        }
        return (MavenRepositoryURL)this.get(this.m_pid + ".localRepository");
    }

    @Override
    public Boolean useFallbackRepositories() {
        if (!this.contains(this.m_pid + ".useFallbackRepositories")) {
            String useFallbackRepoProp = this.m_propertyResolver.get(this.m_pid + ".useFallbackRepositories");
            return this.set(this.m_pid + ".useFallbackRepositories", Boolean.valueOf(useFallbackRepoProp == null ? "true" : useFallbackRepoProp));
        }
        return (Boolean)this.get(this.m_pid + ".useFallbackRepositories");
    }

    @Override
    public void enableProxy(URL url) {
        String proxySupport = this.m_propertyResolver.get(this.m_pid + ".proxySupport");
        if ("false".equalsIgnoreCase(proxySupport)) {
            return;
        }
        String protocol = url.getProtocol();
        if (protocol == null || protocol.equals(this.get(this.m_pid + ".proxySupport"))) {
            return;
        }
        Map<String, String> proxyDetails = this.m_settings.getProxySettings().get(protocol);
        if (proxyDetails != null) {
            LOGGER.trace((Object)("Enabling proxy [" + proxyDetails + "]"));
            final String user = proxyDetails.get("user");
            final String pass = proxyDetails.get("pass");
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, pass.toCharArray());
                }
            });
            System.setProperty(protocol + ".proxyHost", proxyDetails.get("host"));
            System.setProperty(protocol + ".proxyPort", proxyDetails.get("port"));
            System.setProperty(protocol + ".nonProxyHosts", proxyDetails.get("nonProxyHosts"));
            this.set(this.m_pid + ".proxySupport", protocol);
        }
    }

    @Override
    public Boolean isAetherDisabled() {
        if (!this.contains(this.m_pid + ".disableAether")) {
            return this.set(this.m_pid + ".disableAether", Boolean.valueOf(this.m_propertyResolver.get(this.m_pid + ".disableAether")));
        }
        return (Boolean)this.get(this.m_pid + ".disableAether");
    }
}

