/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.Version;
import io.fabric8.boot.commands.support.FabricCommand;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;

@Command(name="version-delete", scope="fabric", description="Delete the specified version, together with all of its associated profile data")
public class VersionDelete
extends FabricCommand {
    @Argument(index=0, name="version", description="The version to delete", required=true, multiValued=false)
    private String versionName;

    protected Object doExecute() throws Exception {
        Version version = this.fabricService.getVersion(this.versionName);
        if (version == null) {
            throw new IllegalArgumentException("Cannot find version: " + this.versionName);
        }
        StringBuilder sb = new StringBuilder();
        for (Container container : this.fabricService.getContainers()) {
            if (!version.equals(container.getVersion())) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(container.getId());
        }
        if (sb.length() > 0) {
            throw new IllegalArgumentException("Version " + this.versionName + " is still in used by the following containers: " + sb.toString());
        }
        version.delete();
        return null;
    }
}

