/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="container-resolver-list", scope="fabric", description="List the resolver policy and the host data for each container in the fabric", detailedDescription="classpath:containerResolverList.txt")
public class ContainerResolverListAction
extends AbstractAction {
    static final String FORMAT = "%-16s %-16s %-16s %-16s %-32s %-16s %-32s";
    static final String[] HEADERS = new String[]{"[id]", "[resolver]", "[local hostname]", "[local ip]", "[public hostname]", "[public ip]", "[manual ip]"};
    @Argument(index=0, name="container", description="The list of containers to display. Empty list assumes current container only.", required=false, multiValued=true)
    private List<String> containerIds;
    private final FabricService fabricService;

    ContainerResolverListAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        if (this.containerIds == null || this.containerIds.isEmpty()) {
            this.containerIds = new ArrayList<String>();
            for (Container container : this.fabricService.getContainers()) {
                this.containerIds.add(container.getId());
            }
        }
        System.out.println(String.format(FORMAT, HEADERS));
        for (String containerId : this.containerIds) {
            Container container = this.fabricService.getContainer(containerId);
            String localHostName = container.getLocalHostname();
            String localIp = container.getLocalIp();
            String publicHostName = container.getPublicHostname();
            String publicIp = container.getPublicIp();
            String manualIp = container.getManualIp();
            localHostName = localHostName != null ? localHostName : "";
            localIp = localIp != null ? localIp : "";
            publicHostName = publicHostName != null ? publicHostName : "";
            publicIp = publicIp != null ? publicIp : "";
            manualIp = manualIp != null ? manualIp : "";
            String resolver = container.getResolver();
            System.out.println(String.format(FORMAT, containerId, resolver, localHostName, localIp, publicHostName, publicIp, manualIp));
        }
        return null;
    }
}

