/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.utils.FabricValidations;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="container-jmx-domains", scope="fabric", description="Lists a container's JMX domains")
public class ContainerDomainsAction
extends AbstractAction {
    @Argument(index=0, name="container", description="The container name", required=true, multiValued=false)
    private String container = null;
    private final FabricService fabricService;

    ContainerDomainsAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        FabricValidations.validateContainerName(this.container);
        Container found = FabricCommand.getContainer(this.fabricService, this.container);
        List domains = found.getJmxDomains();
        for (String domain : domains) {
            System.out.println(domain);
        }
        return null;
    }
}

