/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.boot.commands.support;

import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.FabricAuthenticationException;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.api.ZooKeeperClusterService;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.utils.FabricValidations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.felix.gogo.commands.Option;
import org.osgi.framework.ServiceReference;

public abstract class ContainerCreateSupport
extends FabricCommand {
    @Option(name="--version", description="The version of the new container (must be an existing version). Defaults to the current default version.")
    protected String version;
    @Option(name="--profile", multiValued=true, required=false, description="The profile IDs to associate with the new container(s). For multiple profiles, specify the flag multiple times. Defaults to the profile named, default.")
    protected Set<String> profiles;
    @Option(name="--resolver", multiValued=false, required=false, description="The resolver policy for this container(s). Possible values are: localip, localhostname, publicip, publichostname, manualip. Defaults to the fabric's default resolver policy.")
    protected String resolver;
    @Option(name="-m", aliases={"--manual-ip"}, description="An address to use, when using the manualip resolver.")
    protected String manualIp;
    @Option(name="-b", aliases={"--bind-address"}, description="The default bind address.")
    protected String bindAddress;
    @Option(name="--ensemble-server", multiValued=false, required=false, description="Whether the new container should be a fabric ensemble server (ZooKeeper ensemble server).")
    protected Boolean isEnsembleServer = Boolean.FALSE;
    @Option(name="--zookeeper-password", multiValued=false, description="The ensemble password to use (one will be generated if not given)")
    protected String zookeeperPassword;
    @Option(name="--jvm-opts", multiValued=false, required=false, description="Options to pass to the container's JVM.")
    protected String jvmOpts;
    @Option(name="--datastore-type", multiValued=false, required=false, description="Options to pass to the container's datastore type.")
    protected String dataStoreType;
    @Option(name="--datastore-option", multiValued=true, required=false, description="Options to pass to the container's datastore.")
    protected String[] dataStoreOption;

    public Set<String> getProfileNames() {
        Set<String> names = this.profiles;
        if (names == null || names.isEmpty()) {
            names = new LinkedHashSet<String>();
            names.add("default");
        }
        return names;
    }

    protected void preCreateContainer(String name) throws IllegalArgumentException {
        FabricValidations.validateContainersName(name);
        if (!this.isEnsembleServer.booleanValue()) {
            ZooKeeperClusterService zkcs;
            ServiceReference sr = this.getBundleContext().getServiceReference(ZooKeeperClusterService.class.getName());
            ZooKeeperClusterService zooKeeperClusterService = zkcs = sr != null ? (ZooKeeperClusterService)this.getService(ZooKeeperClusterService.class, sr) : null;
            if (zkcs == null) {
                throw new IllegalStateException("Unable to find ZooKeeperClusterService service");
            }
            if (zkcs.getEnsembleContainers().isEmpty()) {
                if (!this.isEnsembleServer.booleanValue()) {
                    throw new IllegalStateException("The use of the --ensemble-server option is mandatory when creating an initial container");
                }
                return;
            }
            if (this.doesContainerExist(name)) {
                throw new IllegalArgumentException("A container with name " + name + " already exists.");
            }
            Version ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
            Profile[] profiles = ver.getProfiles();
            Set<String> names = this.getProfileNames();
            for (String profile : names) {
                Profile prof = ContainerCreateSupport.getProfile(profiles, profile, ver);
                if (prof == null) {
                    throw new IllegalArgumentException("Profile " + profile + " with version " + ver.getId() + " does not exist.");
                }
                if (!prof.isAbstract()) continue;
                throw new IllegalArgumentException("Profile " + profile + " with version " + ver.getId() + " is abstract and can not be associated to containers.");
            }
        }
        if (!this.isEnsembleServer.booleanValue() && this.fabricService.getZookeeperUrl() == null) {
            throw new IllegalArgumentException("Either start a zookeeper ensemble or use --ensemble-server.");
        }
    }

    protected void displayContainers(CreateContainerMetadata[] metadatas) {
        ArrayList<CreateContainerMetadata> success = new ArrayList<CreateContainerMetadata>();
        ArrayList failures = new ArrayList();
        for (CreateContainerMetadata metadata : metadatas) {
            (metadata.isSuccess() ? success : failures).add(metadata);
        }
        if (success.size() > 0) {
            System.out.println("The following containers have been created successfully:");
            for (CreateContainerMetadata m : success) {
                System.out.println("\t" + m.toString());
            }
        }
        if (failures.size() > 0) {
            System.out.println("The following containers have failed:");
            for (CreateContainerMetadata m : failures) {
                System.out.println("\t" + m.getContainerName() + ": " + m.getFailure().getMessage());
            }
        }
    }

    protected void rethrowAuthenticationErrors(CreateContainerMetadata[] metadata) {
        FabricAuthenticationException rethrow = null;
        for (CreateContainerMetadata md : metadata) {
            if (!(md.getFailure() instanceof FabricAuthenticationException)) {
                return;
            }
            rethrow = (FabricAuthenticationException)md.getFailure();
        }
        if (rethrow != null) {
            throw rethrow;
        }
    }

    private static Profile getProfile(Profile[] profiles, String name, Version version) {
        if (profiles == null || profiles.length == 0) {
            return null;
        }
        for (Profile profile : profiles) {
            if (!profile.getId().equals(name) || !profile.getVersion().equals(version.getId())) continue;
            return profile;
        }
        return null;
    }

    public Map<String, String> getDataStoreProperties() {
        HashMap<String, String> options = new HashMap<String, String>(this.fabricService.getDataStore().getDataStoreProperties());
        if (this.dataStoreOption != null) {
            for (String opt : this.dataStoreOption) {
                String[] parts = opt.trim().split(" +");
                options.put(parts[0], parts[1]);
            }
        }
        return options;
    }
}

