/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.tools;

import com.floragunn.searchguard.crypto.BCrypt;
import java.io.Console;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class Hasher {
    public static void main(String[] args) {
        Options options = new Options();
        HelpFormatter formatter = new HelpFormatter();
        options.addOption(Option.builder((String)"p").argName("password").hasArg().desc("Cleartext password to hash").build());
        options.addOption(Option.builder((String)"env").argName("name environment variable").hasArg().desc("name environment variable to read password from").build());
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("p")) {
                System.out.println(Hasher.hash(line.getOptionValue("p").getBytes("UTF-8")));
            } else if (line.hasOption("env")) {
                String pwd = System.getenv(line.getOptionValue("env"));
                if (pwd == null || pwd.isEmpty()) {
                    throw new Exception("No environment variable '" + line.getOptionValue("env") + "' set");
                }
                System.out.println(Hasher.hash(pwd.getBytes("UTF-8")));
            } else {
                Console console = System.console();
                if (console == null) {
                    throw new Exception("Cannot allocate a console");
                }
                char[] passwd = console.readPassword("[%s]", "Password:");
                System.out.println(Hasher.hash(new String(passwd).getBytes("UTF-8")));
            }
        }
        catch (Exception exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            formatter.printHelp("hasher.sh", options, true);
            System.exit(-1);
        }
    }

    public static String hash(byte[] clearTextPassword) {
        return BCrypt.hashpw(Objects.requireNonNull(clearTextPassword), BCrypt.gensalt(12));
    }
}

