/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.rest;

import com.floragunn.searchguard.configuration.PrivilegesEvaluator;
import com.floragunn.searchguard.user.User;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class SearchGuardInfoAction
extends BaseRestHandler {
    private final PrivilegesEvaluator evaluator;
    private final ThreadContext threadContext;

    public SearchGuardInfoAction(Settings settings, RestController controller, PrivilegesEvaluator evaluator, ThreadPool threadPool) {
        super(settings);
        this.threadContext = threadPool.getThreadContext();
        this.evaluator = evaluator;
        controller.registerHandler(RestRequest.Method.GET, "/_searchguard/authinfo", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_searchguard/authinfo", (RestHandler)this);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            public void accept(RestChannel channel) throws Exception {
                XContentBuilder builder = channel.newBuilder();
                BytesRestResponse response = null;
                try {
                    X509Certificate[] certs = (X509Certificate[])SearchGuardInfoAction.this.threadContext.getTransient("_sg_ssl_peer_certificates");
                    User user = (User)SearchGuardInfoAction.this.threadContext.getTransient("_sg_user");
                    TransportAddress remoteAddress = (TransportAddress)SearchGuardInfoAction.this.threadContext.getTransient("_sg_remote_address");
                    builder.startObject();
                    builder.field("user", (Object)user);
                    builder.field("user_name", user == null ? null : user.getName());
                    builder.field("user_requested_tenant", user == null ? null : user.getRequestedTenant());
                    builder.field("remote_address", (Object)remoteAddress);
                    builder.field("sg_roles", SearchGuardInfoAction.this.evaluator.mapSgRoles(user, remoteAddress));
                    builder.field("sg_tenants", SearchGuardInfoAction.this.evaluator.mapTenants(user, remoteAddress));
                    builder.field("principal", (String)SearchGuardInfoAction.this.threadContext.getTransient("_sg_ssl_principal"));
                    builder.field("peer_certificates", certs != null && certs.length > 0 ? certs.length + "" : "0");
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.OK, builder);
                }
                catch (Exception e1) {
                    builder = channel.newBuilder();
                    builder.startObject();
                    builder.field("error", e1.toString());
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }
}

