/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.searchguard.configuration.ConfigurationRepository;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.common.settings.Settings;

public class ActionGroupHolder {
    final ConfigurationRepository configurationRepository;

    public ActionGroupHolder(ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
    }

    public Set<String> getGroupMembers(String groupname) {
        Settings actionGroups = this.getSettings();
        if (actionGroups == null) {
            return Collections.emptySet();
        }
        return this.resolve(actionGroups, groupname);
    }

    private Set<String> resolve(Settings actionGroups, String entry) {
        HashSet<String> ret = new HashSet<String>();
        String[] en = actionGroups.getAsArray(entry);
        for (int i = 0; i < en.length; ++i) {
            String string = en[i];
            if (actionGroups.names().contains(string)) {
                ret.addAll(this.resolve(actionGroups, string));
                continue;
            }
            ret.add(string);
        }
        return ret;
    }

    private Settings getSettings() {
        return this.configurationRepository.getConfiguration("actiongroups");
    }
}

