/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.auth;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.auth.AuthDomain;
import com.floragunn.searchguard.auth.AuthenticationBackend;
import com.floragunn.searchguard.auth.AuthorizationBackend;
import com.floragunn.searchguard.auth.HTTPAuthenticator;
import com.floragunn.searchguard.auth.internal.InternalAuthenticationBackend;
import com.floragunn.searchguard.auth.internal.NoOpAuthenticationBackend;
import com.floragunn.searchguard.auth.internal.NoOpAuthorizationBackend;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.http.HTTPBasicAuthenticator;
import com.floragunn.searchguard.http.HTTPClientCertAuthenticator;
import com.floragunn.searchguard.http.HTTPHostAuthenticator;
import com.floragunn.searchguard.http.HTTPProxyAuthenticator;
import com.floragunn.searchguard.http.XFFResolver;
import com.floragunn.searchguard.support.HTTPHelper;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;

public class BackendRegistry
implements ConfigurationChangeListener {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final Map<String, String> authImplMap = new HashMap<String, String>();
    private final SortedSet<AuthDomain> authDomains = new TreeSet<AuthDomain>();
    private final Set<AuthorizationBackend> authorizers = new HashSet<AuthorizationBackend>();
    private volatile boolean initialized;
    private final AdminDNs adminDns;
    private final XFFResolver xffResolver;
    private volatile boolean anonymousAuthEnabled = false;
    private final Settings esSettings;
    private final InternalAuthenticationBackend iab;
    private final AuditLog auditLog;
    private final ThreadPool threadPool;
    private final int ttlInMin;
    private Cache<AuthCredentials, User> userCache;
    private Cache<String, User> userCacheTransport;
    private Cache<AuthCredentials, User> authenticatedUserCacheTransport;

    private void createCaches() {
        this.userCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<AuthCredentials, User>(){

            public void onRemoval(RemovalNotification<AuthCredentials, User> notification) {
                BackendRegistry.this.log.debug("Clear user cache for {} due to {}", (Object)((AuthCredentials)notification.getKey()).getUsername(), (Object)notification.getCause());
            }
        }).build();
        this.userCacheTransport = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, User>(){

            public void onRemoval(RemovalNotification<String, User> notification) {
                BackendRegistry.this.log.debug("Clear user cache for {} due to {}", notification.getKey(), (Object)notification.getCause());
            }
        }).build();
        this.authenticatedUserCacheTransport = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<AuthCredentials, User>(){

            public void onRemoval(RemovalNotification<AuthCredentials, User> notification) {
                BackendRegistry.this.log.debug("Clear user cache for {} due to {}", (Object)((AuthCredentials)notification.getKey()).getUsername(), (Object)notification.getCause());
            }
        }).build();
    }

    public BackendRegistry(Settings settings, AdminDNs adminDns, XFFResolver xffResolver, InternalAuthenticationBackend iab, AuditLog auditLog, ThreadPool threadPool) {
        this.adminDns = adminDns;
        this.esSettings = settings;
        this.xffResolver = xffResolver;
        this.iab = iab;
        this.auditLog = auditLog;
        this.threadPool = threadPool;
        this.authImplMap.put("intern_c", InternalAuthenticationBackend.class.getName());
        this.authImplMap.put("intern_z", NoOpAuthorizationBackend.class.getName());
        this.authImplMap.put("internal_c", InternalAuthenticationBackend.class.getName());
        this.authImplMap.put("internal_z", NoOpAuthorizationBackend.class.getName());
        this.authImplMap.put("noop_c", NoOpAuthenticationBackend.class.getName());
        this.authImplMap.put("noop_z", NoOpAuthorizationBackend.class.getName());
        this.authImplMap.put("ldap_c", "com.floragunn.dlic.auth.ldap.backend.LDAPAuthenticationBackend");
        this.authImplMap.put("ldap_z", "com.floragunn.dlic.auth.ldap.backend.LDAPAuthorizationBackend");
        this.authImplMap.put("basic_h", HTTPBasicAuthenticator.class.getName());
        this.authImplMap.put("proxy_h", HTTPProxyAuthenticator.class.getName());
        this.authImplMap.put("clientcert_h", HTTPClientCertAuthenticator.class.getName());
        this.authImplMap.put("kerberos_h", "com.floragunn.dlic.auth.http.kerberos.HTTPSpnegoAuthenticator");
        this.authImplMap.put("jwt_h", "com.floragunn.dlic.auth.http.jwt.HTTPJwtAuthenticator");
        this.authImplMap.put("host_h", HTTPHostAuthenticator.class.getName());
        this.ttlInMin = settings.getAsInt("searchguard.cache.ttl_minutes", Integer.valueOf(60));
        this.createCaches();
    }

    public void invalidateCache() {
        this.userCache.invalidateAll();
        this.userCacheTransport.invalidateAll();
        this.authenticatedUserCacheTransport.invalidateAll();
    }

    private <T> T newInstance(String clazzOrShortcut, String type, Settings settings) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String clazz = clazzOrShortcut;
        if (this.authImplMap.containsKey(clazz + "_" + type)) {
            clazz = this.authImplMap.get(clazz + "_" + type);
        }
        Class<?> t = Class.forName(clazz);
        Constructor<?> tctor = t.getConstructor(Settings.class);
        return (T)tctor.newInstance(settings);
    }

    @Override
    public void onChange(Settings settings) {
        this.authDomains.clear();
        this.authorizers.clear();
        this.anonymousAuthEnabled = settings.getAsBoolean("searchguard.dynamic.http.anonymous_auth_enabled", Boolean.valueOf(false));
        Map authzDyn = settings.getGroups("searchguard.dynamic.authz");
        for (String ad : authzDyn.keySet()) {
            Settings ads = (Settings)authzDyn.get(ad);
            if (!ads.getAsBoolean("enabled", Boolean.valueOf(true)).booleanValue()) continue;
            try {
                AuthorizationBackend authorizationBackend = (AuthorizationBackend)this.newInstance(ads.get("authorization_backend.type", "noop"), "z", Settings.builder().put(this.esSettings).put(ads.getAsSettings("authorization_backend.config")).build());
                this.authorizers.add(authorizationBackend);
            }
            catch (Exception e) {
                this.log.error("Unable to initialize AuthorizationBackend {} due to {}", (Object)e, (Object)ad, (Object)e.toString());
            }
        }
        Map dyn = settings.getGroups("searchguard.dynamic.authc");
        for (String ad : dyn.keySet()) {
            Settings ads = (Settings)dyn.get(ad);
            if (!ads.getAsBoolean("enabled", Boolean.valueOf(true)).booleanValue()) continue;
            try {
                String authBackendClazz = ads.get("authentication_backend.type", InternalAuthenticationBackend.class.getName());
                AuthenticationBackend authenticationBackend = authBackendClazz.equals(InternalAuthenticationBackend.class.getName()) || authBackendClazz.equals("internal") || authBackendClazz.equals("intern") ? this.iab : (AuthenticationBackend)this.newInstance(authBackendClazz, "c", Settings.builder().put(this.esSettings).put(ads.getAsSettings("authentication_backend.config")).build());
                String httpAuthenticatorType = ads.get("http_authenticator.type");
                HTTPAuthenticator httpAuthenticator = httpAuthenticatorType == null ? null : (HTTPAuthenticator)this.newInstance(httpAuthenticatorType, "h", Settings.builder().put(this.esSettings).put(ads.getAsSettings("http_authenticator.config")).build());
                this.authDomains.add(new AuthDomain(authenticationBackend, httpAuthenticator, ads.getAsBoolean("http_authenticator.challenge", Boolean.valueOf(true)), ads.getAsInt("order", Integer.valueOf(0))));
            }
            catch (Exception e) {
                this.log.error("Unable to initialize auth domain {} due to {}", (Object)ad, (Object)e.toString(), (Object)e);
            }
        }
        if (this.authDomains.isEmpty()) {
            this.authDomains.add(new AuthDomain(this.iab, new HTTPBasicAuthenticator(Settings.EMPTY), true, 0));
        }
        this.initialized = true;
    }

    public User authenticate(TransportRequest request, TransportChannel channel, String sslPrincipal) throws ElasticsearchSecurityException {
        User user;
        User origPKIUser = new User(sslPrincipal);
        User impersonatedUser = this.impersonate(request, channel, origPKIUser);
        User user2 = user = impersonatedUser == null ? origPKIUser : impersonatedUser;
        if (AdminDNs.isAdmin(user.getName())) {
            this.auditLog.logAuthenticatedRequest(request, channel.action());
            return user;
        }
        AuthCredentials _creds = null;
        String authorizationHeader = this.threadPool.getThreadContext().getHeader("Authorization");
        final AuthCredentials creds = _creds = HTTPHelper.extractCredentials(authorizationHeader, this.log);
        if (this.log.isDebugEnabled() && creds != null) {
            this.log.debug("User {} submitted also basic credentials: {}", (Object)user.getName(), (Object)creds);
        }
        for (final AuthDomain authDomain : new TreeSet<AuthDomain>(this.authDomains)) {
            User authenticatedUser = null;
            if (creds == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Transport User '{}' is in cache? {} (cache size: {})", (Object)user.getName(), (Object)(this.userCacheTransport.getIfPresent((Object)user.getName()) != null ? 1 : 0), (Object)this.userCacheTransport.size());
                }
                try {
                    authenticatedUser = (User)this.userCacheTransport.get((Object)user.getName(), (Callable)new Callable<User>(){

                        @Override
                        public User call() throws Exception {
                            if (BackendRegistry.this.log.isDebugEnabled()) {
                                BackendRegistry.this.log.debug(user.getName() + " not cached, return from {} backend directly", (Object)authDomain.getBackend().getType());
                            }
                            if (authDomain.getBackend().exists(user)) {
                                for (AuthorizationBackend ab : BackendRegistry.this.authorizers) {
                                    try {
                                        ab.fillRoles(user, new AuthCredentials(user.getName(), new String[0]));
                                    }
                                    catch (Exception e) {
                                        BackendRegistry.this.log.error("Problems retrieving roles for {} from {}", (Object)user, ab.getClass());
                                    }
                                }
                                return user;
                            }
                            throw new Exception("no such user " + user.getName());
                        }
                    });
                }
                catch (Exception e) {
                    this.log.debug("Cannot authenticate {} with {}, try next", (Object)user.getName(), (Object)authDomain.getBackend().getType(), (Object)e);
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Transport User '{}' is in cache? {} (cache size: {})", (Object)creds.getUsername(), (Object)(this.authenticatedUserCacheTransport.getIfPresent((Object)creds) != null ? 1 : 0), (Object)this.authenticatedUserCacheTransport.size());
                }
                try {
                    authenticatedUser = (User)this.authenticatedUserCacheTransport.get((Object)creds, (Callable)new Callable<User>(){

                        @Override
                        public User call() throws Exception {
                            if (BackendRegistry.this.log.isDebugEnabled()) {
                                BackendRegistry.this.log.debug(creds.getUsername() + " not cached, return from {} backend directly", (Object)authDomain.getBackend().getType());
                            }
                            User _user = authDomain.getBackend().authenticate(creds);
                            for (AuthorizationBackend ab : BackendRegistry.this.authorizers) {
                                try {
                                    ab.fillRoles(_user, new AuthCredentials(_user.getName(), new String[0]));
                                }
                                catch (Exception e) {
                                    BackendRegistry.this.log.error("Problems retrieving roles for {} from {}", (Object)_user, ab.getClass());
                                }
                            }
                            return _user;
                        }
                    });
                }
                catch (Exception e) {
                    this.log.debug("Cannot authenticate {} with {}, try next", (Object)creds.getUsername(), (Object)authDomain.getBackend().getType(), (Object)e);
                }
            }
            if (authenticatedUser == null) continue;
            if (AdminDNs.isAdmin(authenticatedUser.getName())) {
                if (creds != null) {
                    creds.clearSecrets();
                }
                this.log.error("Cannot authenticate user because admin user is not permitted to login");
                this.auditLog.logFailedLogin(authenticatedUser.getName(), request);
                return null;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("User '{}' is authenticated", (Object)authenticatedUser);
            }
            if (creds != null) {
                creds.clearSecrets();
            }
            return authenticatedUser;
        }
        if (creds == null) {
            this.auditLog.logFailedLogin(user.getName(), request);
        } else {
            creds.clearSecrets();
            this.auditLog.logFailedLogin(creds.getUsername(), request);
        }
        this.log.warn("Transport authentication finally failed for {}", (Object)(creds == null ? user.getName() : creds.getUsername()));
        return null;
    }

    public boolean authenticate(RestRequest request, RestChannel channel, ThreadContext threadContext) throws ElasticsearchSecurityException {
        String sslPrincipal = (String)this.threadPool.getThreadContext().getTransient("_sg_ssl_principal");
        if (AdminDNs.isAdmin(sslPrincipal)) {
            this.threadPool.getThreadContext().putTransient("_sg_user", (Object)new User(sslPrincipal));
            return true;
        }
        if (!this.isInitialized()) {
            this.log.error("Not yet initialized (you may need to run sgadmin)");
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.SERVICE_UNAVAILABLE, "Search Guard not initialized (SG11). See https://github.com/floragunncom/search-guard-docs/blob/master/sgadmin.md"));
            return false;
        }
        threadContext.putTransient("_sg_remote_address", (Object)this.xffResolver.resolve(request));
        boolean authenticated = false;
        User authenticatedUser = null;
        AuthCredentials authCredenetials = null;
        HTTPAuthenticator firstChallengingHttpAuthenticator = null;
        for (final AuthDomain authDomain : new TreeSet<AuthDomain>(this.authDomains)) {
            AuthCredentials ac;
            HTTPAuthenticator httpAuthenticator = authDomain.getHttpAuthenticator();
            if (httpAuthenticator == null) continue;
            if (authDomain.isChallenge() && firstChallengingHttpAuthenticator == null) {
                firstChallengingHttpAuthenticator = httpAuthenticator;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Try to extract auth creds from http {} ", (Object)httpAuthenticator.getType());
            }
            try {
                ac = httpAuthenticator.extractCredentials(request, threadContext);
            }
            catch (Exception e1) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("'{}' extracting credentials from {} authenticator", (Object)e1, (Object)httpAuthenticator.getType());
                continue;
            }
            authCredenetials = ac;
            if (ac == null) {
                if (this.anonymousAuthEnabled || !authDomain.isChallenge() || !httpAuthenticator.reRequestAuthentication(channel, null)) continue;
                this.auditLog.logFailedLogin(null, request);
                return false;
            }
            if (!ac.isComplete()) {
                if (!httpAuthenticator.reRequestAuthentication(channel, ac)) continue;
                this.auditLog.logFailedLogin(ac.getUsername() + " <incomplete>", request);
                return false;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("User '{}' is in cache? {} (cache size: {})", (Object)ac.getUsername(), (Object)(this.userCache.getIfPresent((Object)ac) != null ? 1 : 0), (Object)this.userCache.size());
            }
            try {
                try {
                    authenticatedUser = (User)this.userCache.get((Object)ac, (Callable)new Callable<User>(){

                        @Override
                        public User call() throws Exception {
                            if (BackendRegistry.this.log.isDebugEnabled()) {
                                BackendRegistry.this.log.debug(ac.getUsername() + " not cached, return from " + authDomain.getBackend().getType() + " backend directly");
                            }
                            User authenticatedUser = authDomain.getBackend().authenticate(ac);
                            for (AuthorizationBackend ab : BackendRegistry.this.authorizers) {
                                try {
                                    ab.fillRoles(authenticatedUser, new AuthCredentials(authenticatedUser.getName(), new String[0]));
                                }
                                catch (Exception e) {
                                    BackendRegistry.this.log.error("Problems retrieving roles for {} from {}", (Object)authenticatedUser, ab.getClass());
                                }
                            }
                            return authenticatedUser;
                        }
                    });
                }
                catch (Exception e) {
                    throw new ElasticsearchSecurityException(e.toString(), e, new Object[0]);
                }
                finally {
                    ac.clearSecrets();
                }
                if (authenticatedUser == null) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Cannot authenticate user (or add roles) with ad {} due to user is null, try next", (Object)authDomain.getOrder());
                    continue;
                }
                if (AdminDNs.isAdmin(authenticatedUser.getName())) {
                    this.log.error("Cannot authenticate user because admin user is not permitted to login via HTTP");
                    this.auditLog.logFailedLogin(authenticatedUser.getName(), request);
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Cannot authenticate user because admin user is not permitted to login via HTTP"));
                    return false;
                }
                String tenant = request.header("sg_tenant");
                if (this.log.isDebugEnabled()) {
                    this.log.debug("User '{}' is authenticated", (Object)authenticatedUser);
                    this.log.debug("sg_tenant '{}'", (Object)tenant);
                }
                authenticatedUser.setRequestedTenant(tenant);
                threadContext.putTransient("_sg_user", (Object)authenticatedUser);
                authenticated = true;
                break;
            }
            catch (ElasticsearchSecurityException e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Cannot authenticate user (or add roles) with ad {} due to {}, try next", (Object)authDomain.getOrder(), (Object)e.toString());
            }
        }
        if (!authenticated) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("User not authenticated after checking {} auth domains", (Object)this.authDomains.size());
            }
            if (authCredenetials == null && this.anonymousAuthEnabled) {
                threadContext.putTransient("_sg_user", (Object)User.ANONYMOUS);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Anonymous User is authenticated");
                }
                return true;
            }
            if (firstChallengingHttpAuthenticator != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Rerequest with {}", firstChallengingHttpAuthenticator.getClass());
                }
                if (firstChallengingHttpAuthenticator.reRequestAuthentication(channel, null)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Rerequest {} failed", firstChallengingHttpAuthenticator.getClass());
                    }
                    this.log.warn("Authentication finally failed for {}", (Object)(authCredenetials == null ? null : authCredenetials.getUsername()));
                    this.auditLog.logFailedLogin(authCredenetials == null ? null : authCredenetials.getUsername(), request);
                    return false;
                }
            }
            this.log.warn("Authentication finally failed for {}", (Object)(authCredenetials == null ? null : authCredenetials.getUsername()));
            this.auditLog.logFailedLogin(authCredenetials == null ? null : authCredenetials.getUsername(), request);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.UNAUTHORIZED, "Authentication finally failed"));
            return false;
        }
        return authenticated;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private User impersonate(TransportRequest tr, TransportChannel channel, User origPKIuser) throws ElasticsearchSecurityException {
        String impersonatedUser = this.threadPool.getThreadContext().getHeader("sg_impersonate_as");
        if (Strings.isNullOrEmpty((String)impersonatedUser)) {
            return null;
        }
        if (!this.isInitialized()) {
            throw new ElasticsearchSecurityException("Could not check for impersonation because Search Guard is not yet initialized", new Object[0]);
        }
        if (origPKIuser == null) {
            throw new ElasticsearchSecurityException("no original PKI user found", new Object[0]);
        }
        User aU = origPKIuser;
        if (AdminDNs.isAdmin(impersonatedUser)) {
            throw new ElasticsearchSecurityException("'" + origPKIuser.getName() + "' is not allowed to impersonate as an adminuser  '" + impersonatedUser + "'", new Object[0]);
        }
        try {
            if (impersonatedUser != null && !this.adminDns.isImpersonationAllowed(new LdapName(origPKIuser.getName()), impersonatedUser)) {
                throw new ElasticsearchSecurityException("'" + origPKIuser.getName() + "' is not allowed to impersonate as '" + impersonatedUser + "'", new Object[0]);
            }
            if (impersonatedUser != null) {
                aU = new User(impersonatedUser);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Impersonate from '{}' to '{}'", (Object)origPKIuser.getName(), (Object)impersonatedUser);
                }
                this.auditLog.logAuthenticatedRequest(tr, channel.action());
            }
        }
        catch (InvalidNameException e1) {
            throw new ElasticsearchSecurityException("PKI does not have a valid name ('" + origPKIuser.getName() + "'), should never happen", (Exception)e1, new Object[0]);
        }
        return aU;
    }
}

