/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.searchguard.SearchGuardPlugin;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.configuration.ActionGroupHolder;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.PrivilegesInterceptor;
import com.floragunn.searchguard.support.Base64Helper;
import com.floragunn.searchguard.support.ConfigConstants;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchguard.user.User;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.RealtimeRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;

public class PrivilegesEvaluator {
    private static final Set<String> NO_INDICES_SET = Sets.newHashSet((Object[])new String[]{"\\", ";", ",", "/", "|"});
    private static final Set<String> NULL_SET = Sets.newHashSet((Object[])new String[]{null});
    private final Set<String> DLSFLS = ImmutableSet.of((Object)"_dls_", (Object)"_fls_");
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final ClusterService clusterService;
    private final ActionGroupHolder ah;
    private final IndexNameExpressionResolver resolver;
    private final Map<Class<?>, Method> typeCache = Collections.synchronizedMap(new HashMap(100));
    private final Map<Class<?>, Method> typesCache = Collections.synchronizedMap(new HashMap(100));
    private final String[] deniedActionPatterns;
    private final AuditLog auditLog;
    private ThreadContext threadContext;
    private static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.lenientExpandOpen();
    private final ConfigurationRepository configurationRepository;
    private final String searchguardIndex;
    private PrivilegesInterceptor privilegesInterceptor;
    private final boolean enableSnapshotRestorePrivilege;
    private final boolean checkSnapshotRestoreWritePrivileges;

    public PrivilegesEvaluator(ClusterService clusterService, ThreadPool threadPool, ConfigurationRepository configurationRepository, ActionGroupHolder ah, IndexNameExpressionResolver resolver, AuditLog auditLog, Settings settings, PrivilegesInterceptor privilegesInterceptor) {
        this.configurationRepository = configurationRepository;
        this.clusterService = clusterService;
        this.ah = ah;
        this.resolver = resolver;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
        this.searchguardIndex = settings.get("searchguard.config_index_name", "searchguard");
        this.privilegesInterceptor = privilegesInterceptor;
        this.enableSnapshotRestorePrivilege = settings.getAsBoolean("searchguard.enable_snapshot_restore_privilege", Boolean.valueOf(false));
        this.checkSnapshotRestoreWritePrivileges = settings.getAsBoolean("searchguard.check_snapshot_restore_write_privileges", Boolean.valueOf(true));
        ArrayList<String> deniedActionPatternsList = new ArrayList<String>();
        deniedActionPatternsList.add("indices:data/write*");
        deniedActionPatternsList.add("indices:admin/close");
        deniedActionPatternsList.add("indices:admin/delete");
        this.deniedActionPatterns = deniedActionPatternsList.toArray(new String[0]);
    }

    private Settings getRolesSettings() {
        return this.configurationRepository.getConfiguration("roles");
    }

    private Settings getRolesMappingSettings() {
        return this.configurationRepository.getConfiguration("rolesmapping");
    }

    private Settings getConfigSettings() {
        return this.configurationRepository.getConfiguration("config");
    }

    public boolean isInitialized() {
        return this.getRolesSettings() != null && this.getRolesMappingSettings() != null && this.getConfigSettings() != null;
    }

    public PrivEvalResponse evaluate(User user, String action, ActionRequest request) {
        Iterator<Map.Entry<String, Set<String>>> it;
        if (!this.isInitialized()) {
            throw new ElasticsearchSecurityException("Search Guard is not initialized.", new Object[0]);
        }
        PrivEvalResponse presponse = new PrivEvalResponse();
        presponse.missingPrivileges.add(action);
        Settings config = this.getConfigSettings();
        Settings roles = this.getRolesSettings();
        boolean compositeEnabled = config.getAsBoolean("searchguard.dynamic.composite_enabled", Boolean.valueOf(true));
        boolean clusterLevelPermissionRequired = false;
        TransportAddress caller = Objects.requireNonNull((TransportAddress)this.threadContext.getTransient("_sg_remote_address"));
        if (this.log.isDebugEnabled()) {
            this.log.debug("### evaluate permissions for {} on {}", (Object)user, (Object)this.clusterService.localNode().getName());
            this.log.debug("requested {} from {}", (Object)action, (Object)caller);
        }
        if (action.startsWith("cluster:admin/snapshot/restore")) {
            if (this.enableSnapshotRestorePrivilege) {
                return this.evaluateSnapshotRestore(user, action, request, caller);
            }
            this.log.warn(action + " is not allowed for a regular user");
            return presponse;
        }
        if (action.startsWith("internal:indices/admin/upgrade")) {
            action = "indices:admin/upgrade";
        }
        ClusterState clusterState = this.clusterService.state();
        MetaData metaData = clusterState.metaData();
        Tuple<Set<String>, Set<String>> requestedResolvedAliasesIndicesTypes = this.resolve(user, action, (TransportRequest)request, metaData);
        Set<String> requestedResolvedIndices = Collections.unmodifiableSet((Set)requestedResolvedAliasesIndicesTypes.v1());
        HashSet<IndexType> requestedResolvedIndexTypes0 = new HashSet<IndexType>(((Set)requestedResolvedAliasesIndicesTypes.v1()).size() * ((Set)requestedResolvedAliasesIndicesTypes.v2()).size());
        for (String index : (Set)requestedResolvedAliasesIndicesTypes.v1()) {
            for (String type : (Set)requestedResolvedAliasesIndicesTypes.v2()) {
                requestedResolvedIndexTypes0.add(new IndexType(index, type));
            }
        }
        Set<IndexType> requestedResolvedIndexTypes = Collections.unmodifiableSet(requestedResolvedIndexTypes0);
        if (this.log.isDebugEnabled()) {
            this.log.debug("requested resolved indextypes: {}", requestedResolvedIndexTypes);
        }
        if (requestedResolvedIndices.contains(this.searchguardIndex) && WildcardMatcher.matchAny(this.deniedActionPatterns, action)) {
            this.auditLog.logSgIndexAttempt((TransportRequest)request, action);
            this.log.warn(action + " for '{}' index is not allowed for a regular user", (Object)this.searchguardIndex);
            return presponse;
        }
        if (requestedResolvedIndices.contains("_all") && WildcardMatcher.matchAny(this.deniedActionPatterns, action)) {
            this.auditLog.logSgIndexAttempt((TransportRequest)request, action);
            this.log.warn(action + " for '_all' indices is not allowed for a regular user");
            return presponse;
        }
        if (requestedResolvedIndices.contains(this.searchguardIndex) || requestedResolvedIndices.contains("_all")) {
            if (request instanceof SearchRequest) {
                ((SearchRequest)request).requestCache(Boolean.FALSE);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Disable search request cache for this request");
                }
            }
            if (request instanceof RealtimeRequest) {
                ((RealtimeRequest)request).realtime(Boolean.FALSE.booleanValue());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Disable realtime for this request");
                }
            }
        }
        Set<String> sgRoles = this.mapSgRoles(user, caller);
        if (this.log.isDebugEnabled()) {
            this.log.debug("mapped roles for {}: {}", (Object)user.getName(), sgRoles);
        }
        if (this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class) {
            Boolean replaceResult = this.privilegesInterceptor.replaceKibanaIndex(request, action, user, config, requestedResolvedIndices, this.mapTenants(user, caller));
            if (replaceResult == Boolean.TRUE) {
                this.auditLog.logMissingPrivileges(action, (TransportRequest)request);
                return presponse;
            }
            if (replaceResult == Boolean.FALSE) {
                presponse.allowed = true;
                return presponse;
            }
        }
        boolean allowAction = false;
        HashMap dlsQueries = new HashMap();
        HashMap flsFields = new HashMap();
        HashMap<String, Set<IndexType>> leftovers = new HashMap<String, Set<IndexType>>();
        HashSet<String> additionalPermissionsRequired = new HashSet<String>();
        if (request instanceof BulkShardRequest) {
            BulkShardRequest bsr = (BulkShardRequest)request;
            block8: for (BulkItemRequest bir : bsr.items()) {
                switch (bir.request().opType()) {
                    case CREATE: {
                        additionalPermissionsRequired.add("indices:data/write/index");
                        continue block8;
                    }
                    case INDEX: {
                        additionalPermissionsRequired.add("indices:data/write/index");
                        continue block8;
                    }
                    case DELETE: {
                        additionalPermissionsRequired.add("indices:data/write/delete");
                        continue block8;
                    }
                    case UPDATE: {
                        additionalPermissionsRequired.add("indices:data/write/update");
                    }
                }
            }
        }
        presponse.missingPrivileges.addAll(additionalPermissionsRequired);
        if (this.log.isDebugEnabled() && !additionalPermissionsRequired.isEmpty()) {
            this.log.debug("Additional permissions required: " + additionalPermissionsRequired);
        }
        HashSet<IndexType> _requestedResolvedIndexTypesGlobal = new HashSet<IndexType>(requestedResolvedIndexTypes);
        for (String sgRole : sgRoles) {
            Settings sgRoleSettings = roles.getByPrefix(sgRole);
            if (sgRoleSettings.names().isEmpty()) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("sg_role {} is empty", (Object)sgRole);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("---------- evaluate sg_role: {}", (Object)sgRole);
            }
            if (action.startsWith("cluster:") || action.startsWith("indices:admin/template/delete") || action.startsWith("indices:admin/template/get") || action.startsWith("indices:admin/template/put") || action.startsWith("indices:data/read/scroll") || compositeEnabled && action.equals("indices:data/write/bulk") || compositeEnabled && action.equals("indices:admin/aliases") || compositeEnabled && action.equals("indices:data/read/mget") || compositeEnabled && action.equals("indices:data/read/msearch") || compositeEnabled && action.equals("indices:data/read/mtv") || compositeEnabled && action.equals("indices:data/read/coordinate-msearch") || compositeEnabled && action.equals("indices:data/write/reindex") || compositeEnabled && action.equals("indices:data/read/mpercolate")) {
                Set<String> resolvedActions = this.resolveActions(sgRoleSettings.getAsArray(".cluster", new String[0]));
                clusterLevelPermissionRequired = true;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("  resolved cluster actions:{}", resolvedActions);
                }
                if (WildcardMatcher.matchAny(resolvedActions.toArray(new String[0]), action)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("  found a match for '{}' and {}, skip other roles", (Object)sgRole, (Object)action);
                    }
                    presponse.allowed = true;
                    return presponse;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("  not match found a match for '{}' and {}, check next role", (Object)sgRole, (Object)action);
                continue;
            }
            Map permittedAliasesIndices0 = sgRoleSettings.getGroups(".indices");
            HashMap<String, Settings> permittedAliasesIndices = new HashMap<String, Settings>(permittedAliasesIndices0.size());
            for (String origKey : permittedAliasesIndices0.keySet()) {
                permittedAliasesIndices.put(origKey.replace("${user.name}", user.getName()).replace("${user_name}", user.getName()), (Settings)permittedAliasesIndices0.get(origKey));
            }
            HashSet<IndexType> _requestedResolvedIndexTypes = new HashSet<IndexType>(requestedResolvedIndexTypes);
            block11: for (String permittedAliasesIndex : permittedAliasesIndices.keySet()) {
                String ci;
                int i;
                String resolvedRole = sgRole;
                String indexPattern = permittedAliasesIndex;
                String dls = roles.get(resolvedRole + ".indices." + indexPattern + "._dls_");
                Object[] fls = roles.getAsArray(resolvedRole + ".indices." + indexPattern + "._fls_");
                Object[] concreteIndices = new String[]{};
                if (dls != null && dls.length() > 0 || fls != null && fls.length > 0) {
                    concreteIndices = this.resolver.concreteIndexNames(this.clusterService.state(), DEFAULT_INDICES_OPTIONS, new String[]{indexPattern});
                }
                if (dls != null && dls.length() > 0) {
                    dls = dls.replace("${user.name}", user.getName()).replace("${user_name}", user.getName());
                    if (dlsQueries.containsKey(indexPattern)) {
                        ((Set)dlsQueries.get(indexPattern)).add(dls);
                    } else {
                        dlsQueries.put(indexPattern, new HashSet());
                        ((Set)dlsQueries.get(indexPattern)).add(dls);
                    }
                    for (i = 0; i < concreteIndices.length; ++i) {
                        ci = concreteIndices[i];
                        if (dlsQueries.containsKey(ci)) {
                            ((Set)dlsQueries.get(ci)).add(dls);
                            continue;
                        }
                        dlsQueries.put(ci, new HashSet());
                        ((Set)dlsQueries.get(ci)).add(dls);
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("dls query {} for {}", (Object)dls, (Object)Arrays.toString(concreteIndices));
                    }
                }
                if (fls != null && fls.length > 0) {
                    if (flsFields.containsKey(indexPattern)) {
                        ((Set)flsFields.get(indexPattern)).addAll(Sets.newHashSet((Object[])fls));
                    } else {
                        flsFields.put(indexPattern, new HashSet());
                        ((Set)flsFields.get(indexPattern)).addAll(Sets.newHashSet((Object[])fls));
                    }
                    for (i = 0; i < concreteIndices.length; ++i) {
                        ci = concreteIndices[i];
                        if (flsFields.containsKey(ci)) {
                            ((Set)flsFields.get(ci)).addAll(Sets.newHashSet((Object[])fls));
                            continue;
                        }
                        flsFields.put(ci, new HashSet());
                        ((Set)flsFields.get(ci)).addAll(Sets.newHashSet((Object[])fls));
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("fls fields {} for {}", (Object)Sets.newHashSet((Object[])fls), (Object)Arrays.toString(concreteIndices));
                    }
                }
                String[] action0 = null;
                action0 = !additionalPermissionsRequired.isEmpty() ? additionalPermissionsRequired.toArray(new String[0]) : new String[]{action};
                if (WildcardMatcher.containsWildcard(permittedAliasesIndex)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("  Try wildcard match for {}", (Object)permittedAliasesIndex);
                    }
                    this.handleIndicesWithWildcard(action0, permittedAliasesIndex, permittedAliasesIndices, requestedResolvedIndexTypes, _requestedResolvedIndexTypes, _requestedResolvedIndexTypesGlobal, requestedResolvedIndices);
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("  Resolve and match {}", (Object)permittedAliasesIndex);
                    }
                    this.handleIndicesWithoutWildcard(action0, permittedAliasesIndex, permittedAliasesIndices, requestedResolvedIndexTypes, _requestedResolvedIndexTypes, _requestedResolvedIndexTypesGlobal);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("For index {} remaining requested local indextype: {}", (Object)permittedAliasesIndex, _requestedResolvedIndexTypes);
                    this.log.debug("For index {} remaining requested global indextype: {}", (Object)permittedAliasesIndex, _requestedResolvedIndexTypesGlobal);
                }
                if (!_requestedResolvedIndexTypes.isEmpty()) continue;
                for (String requestAliasOrIndex : requestedResolvedIndices) {
                    ArrayList<AliasMetaData> filteredAliases = new ArrayList<AliasMetaData>();
                    IndexMetaData indexMetaData = (IndexMetaData)clusterState.metaData().getIndices().get((Object)requestAliasOrIndex);
                    if (indexMetaData == null) {
                        this.log.warn("{} does not exist in cluster metadata", (Object)requestAliasOrIndex);
                        continue;
                    }
                    ImmutableOpenMap aliases = indexMetaData.getAliases();
                    if (aliases != null && aliases.size() > 0) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Aliases for {}: {}", (Object)requestAliasOrIndex, (Object)aliases);
                        }
                        Iterator it2 = aliases.keysIt();
                        while (it2.hasNext()) {
                            String alias = (String)it2.next();
                            AliasMetaData aliasMetaData = (AliasMetaData)aliases.get((Object)alias);
                            if (aliasMetaData != null && aliasMetaData.filteringRequired()) {
                                filteredAliases.add(aliasMetaData);
                                if (!this.log.isDebugEnabled()) continue;
                                this.log.debug(alias + " is a filtered alias " + aliasMetaData.getFilter());
                                continue;
                            }
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug(alias + " is not an alias or does not have a filter");
                        }
                    }
                    if (filteredAliases.size() <= 1) continue;
                    String faMode = config.get("searchguard.dynamic.filtered_alias_mode", "warn");
                    if (faMode.equals("warn")) {
                        this.log.warn("More than one ({}) filtered alias found for same index ({}). This is currently not recommended. Aliases: {}", (Object)filteredAliases.size(), requestedResolvedIndices, this.toString(filteredAliases));
                        continue;
                    }
                    if (faMode.equals("disallow")) {
                        this.log.error("More than one ({}) filtered alias found for same index ({}). This is currently not supported. Aliases: {}", (Object)filteredAliases.size(), requestedResolvedIndices, this.toString(filteredAliases));
                        continue block11;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("More than one ({}) filtered alias found for same index ({}). Aliases: {}", (Object)filteredAliases.size(), requestedResolvedIndices, this.toString(filteredAliases));
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("found a match for '{}.{}', evaluate other roles", (Object)sgRole, (Object)permittedAliasesIndex);
                }
                allowAction = true;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Added to leftovers {}=>{}", (Object)sgRole, _requestedResolvedIndexTypes);
            }
            leftovers.put(sgRole, _requestedResolvedIndexTypes);
        }
        if (!allowAction && config.getAsBoolean("searchguard.dynamic.multi_rolespan_enabled", Boolean.valueOf(false)).booleanValue()) {
            allowAction = _requestedResolvedIndexTypesGlobal.isEmpty();
        }
        if (!allowAction && this.log.isInfoEnabled()) {
            String[] action0 = !additionalPermissionsRequired.isEmpty() ? additionalPermissionsRequired.toArray(new String[0]) : new String[]{action};
            this.log.info("No {}-level perm match for {} {} [Action [{}]] [RolesChecked {}]", (Object)(clusterLevelPermissionRequired ? "cluster" : "index"), (Object)user, requestedResolvedIndexTypes, (Object)action0, sgRoles);
            this.log.info("No permissions for {}", leftovers);
        }
        if (!dlsQueries.isEmpty()) {
            if (this.threadContext.getHeader("_sg_dls_query") != null) {
                if (!dlsQueries.equals((Map)((Object)Base64Helper.deserializeObject(this.threadContext.getHeader("_sg_dls_query"))))) {
                    throw new ElasticsearchSecurityException("_sg_dls_query does not match (SG 900D)", new Object[0]);
                }
            } else {
                this.threadContext.putHeader("_sg_dls_query", Base64Helper.serializeObject(dlsQueries));
            }
            presponse.queries = new HashMap<String, Set<String>>(dlsQueries);
            if (!requestedResolvedIndices.isEmpty()) {
                it = presponse.queries.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Set<String>> entry = it.next();
                    if (WildcardMatcher.matchAny(entry.getKey(), requestedResolvedIndices, false)) continue;
                    it.remove();
                }
            }
        }
        if (!flsFields.isEmpty()) {
            if (this.threadContext.getHeader("_sg_fls_fields") != null) {
                if (!flsFields.equals((Map)((Object)Base64Helper.deserializeObject(this.threadContext.getHeader("_sg_fls_fields"))))) {
                    throw new ElasticsearchSecurityException("_sg_fls_fields does not match (SG 901D)", new Object[0]);
                }
            } else {
                this.threadContext.putHeader("_sg_fls_fields", Base64Helper.serializeObject(flsFields));
            }
            presponse.allowedFlsFields = new HashMap<String, Set<String>>(flsFields);
            if (!requestedResolvedIndices.isEmpty()) {
                it = presponse.allowedFlsFields.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Set<String>> entry = it.next();
                    if (WildcardMatcher.matchAny(entry.getKey(), requestedResolvedIndices, false)) continue;
                    it.remove();
                }
            }
        }
        if (!allowAction && this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class && leftovers.size() > 0) {
            boolean interceptorAllow;
            presponse.allowed = interceptorAllow = this.privilegesInterceptor.replaceAllowedIndices(request, action, user, config, leftovers);
            return presponse;
        }
        presponse.allowed = allowAction;
        return presponse;
    }

    private PrivEvalResponse evaluateSnapshotRestore(User user, String action, ActionRequest request, TransportAddress caller) {
        PrivEvalResponse presponse = new PrivEvalResponse();
        presponse.missingPrivileges.add(action);
        if (!(request instanceof RestoreSnapshotRequest)) {
            return presponse;
        }
        RestoreSnapshotRequest restoreRequest = (RestoreSnapshotRequest)request;
        if (restoreRequest.includeGlobalState()) {
            this.auditLog.logSgIndexAttempt((TransportRequest)request, action);
            this.log.warn(action + " with 'include_global_state' enabled is not allowed");
            return presponse;
        }
        RepositoriesService repositoriesService = Objects.requireNonNull(SearchGuardPlugin.GuiceHolder.getRepositoriesService(), "RepositoriesService not initialized");
        Repository repository = repositoriesService.repository(restoreRequest.repository());
        SnapshotInfo snapshotInfo = null;
        for (SnapshotId snapshotId : repository.getRepositoryData().getSnapshotIds()) {
            if (!snapshotId.getName().equals(restoreRequest.snapshot())) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("snapshot found: {} (UUID: {})", (Object)snapshotId.getName(), (Object)snapshotId.getUUID());
            }
            snapshotInfo = repository.getSnapshotInfo(snapshotId);
            break;
        }
        if (snapshotInfo == null) {
            this.log.warn(action + " for repository '" + restoreRequest.repository() + "', snapshot '" + restoreRequest.snapshot() + "' not found");
            return presponse;
        }
        List requestedResolvedIndices = SnapshotUtils.filterIndices((List)snapshotInfo.indices(), (String[])restoreRequest.indices(), (IndicesOptions)restoreRequest.indicesOptions());
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolved indices for restore to: {}", (Object)requestedResolvedIndices.toString());
        }
        if (requestedResolvedIndices.contains(this.searchguardIndex) || requestedResolvedIndices.contains("_all")) {
            this.auditLog.logSgIndexAttempt((TransportRequest)request, action);
            this.log.warn(action + " for '{}' as source index is not allowed", (Object)this.searchguardIndex);
            return presponse;
        }
        List<String> renamedTargetIndices = this.renamedIndices(restoreRequest, requestedResolvedIndices);
        if (renamedTargetIndices.contains(this.searchguardIndex) || requestedResolvedIndices.contains("_all")) {
            this.auditLog.logSgIndexAttempt((TransportRequest)request, action);
            this.log.warn(action + " for '{}' as target index is not allowed", (Object)this.searchguardIndex);
            return presponse;
        }
        Set<String> sgRoles = this.mapSgRoles(user, caller);
        if (this.log.isDebugEnabled()) {
            this.log.debug("mapped roles: {}", sgRoles);
        }
        boolean allowedActionSnapshotRestore = false;
        HashSet<String> renamedTargetIndicesSet = new HashSet<String>(renamedTargetIndices);
        HashSet<IndexType> _renamedTargetIndices = new HashSet<IndexType>(renamedTargetIndices.size());
        for (String index : renamedTargetIndices) {
            for (String neededAction : ConfigConstants.SG_SNAPSHOT_RESTORE_NEEDED_WRITE_PRIVILEGES) {
                _renamedTargetIndices.add(new IndexTypeAction(index, "*", neededAction));
            }
        }
        Settings roles = this.getRolesSettings();
        for (String sgRole : sgRoles) {
            Settings sgRoleSettings = roles.getByPrefix(sgRole);
            if (sgRoleSettings.names().isEmpty()) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("sg_role {} is empty", (Object)sgRole);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("---------- evaluate sg_role: {}", (Object)sgRole);
            }
            Set<String> resolvedActions = this.resolveActions(sgRoleSettings.getAsArray(".cluster", new String[0]));
            if (this.log.isDebugEnabled()) {
                this.log.debug("  resolved cluster actions:{}", resolvedActions);
            }
            if (WildcardMatcher.matchAny(resolvedActions.toArray(new String[0]), action)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("  found a match for '{}' and {}, skip other roles", (Object)sgRole, (Object)action);
                }
                allowedActionSnapshotRestore = true;
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("  not match found a match for '{}' and {}, check next role", (Object)sgRole, (Object)action);
            }
            if (!this.checkSnapshotRestoreWritePrivileges) continue;
            Map permittedAliasesIndices0 = sgRoleSettings.getGroups(".indices");
            HashMap<String, Settings> permittedAliasesIndices = new HashMap<String, Settings>(permittedAliasesIndices0.size());
            for (String origKey : permittedAliasesIndices0.keySet()) {
                permittedAliasesIndices.put(origKey.replace("${user.name}", user.getName()).replace("${user_name}", user.getName()), (Settings)permittedAliasesIndices0.get(origKey));
            }
            for (String permittedAliasesIndex : permittedAliasesIndices.keySet()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("  Try wildcard match for {}", (Object)permittedAliasesIndex);
                }
                this.handleSnapshotRestoreWritePrivileges(ConfigConstants.SG_SNAPSHOT_RESTORE_NEEDED_WRITE_PRIVILEGES, permittedAliasesIndex, permittedAliasesIndices, renamedTargetIndicesSet, _renamedTargetIndices);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("For index {} remaining requested indextypeaction: {}", (Object)permittedAliasesIndex, _renamedTargetIndices);
            }
        }
        if (this.checkSnapshotRestoreWritePrivileges && !_renamedTargetIndices.isEmpty()) {
            allowedActionSnapshotRestore = false;
        }
        if (!allowedActionSnapshotRestore) {
            this.auditLog.logMissingPrivileges(action, (TransportRequest)request);
            this.log.info("No perm match for {} [Action [{}]] [RolesChecked {}]", (Object)user, (Object)action, sgRoles);
        }
        presponse.allowed = allowedActionSnapshotRestore;
        return presponse;
    }

    private List<String> renamedIndices(RestoreSnapshotRequest request, List<String> filteredIndices) {
        ArrayList<String> renamedIndices = new ArrayList<String>();
        Iterator<String> iterator = filteredIndices.iterator();
        while (iterator.hasNext()) {
            String index;
            String renamedIndex = index = iterator.next();
            if (request.renameReplacement() != null && request.renamePattern() != null) {
                renamedIndex = index.replaceAll(request.renamePattern(), request.renameReplacement());
            }
            renamedIndices.add(renamedIndex);
        }
        return renamedIndices;
    }

    public Set<String> mapSgRoles(User user, TransportAddress caller) {
        Settings rolesMapping = this.getRolesMappingSettings();
        if (user == null || rolesMapping == null) {
            return Collections.emptySet();
        }
        TreeSet<String> sgRoles = new TreeSet<String>();
        for (String roleMap : rolesMapping.names()) {
            Settings roleMapSettings = rolesMapping.getByPrefix(roleMap);
            if (WildcardMatcher.allPatternsMatched(roleMapSettings.getAsArray(".and_backendroles"), user.getRoles().toArray(new String[0]))) {
                sgRoles.add(roleMap);
                continue;
            }
            if (WildcardMatcher.matchAny(roleMapSettings.getAsArray(".backendroles"), user.getRoles().toArray(new String[0]))) {
                sgRoles.add(roleMap);
                continue;
            }
            if (WildcardMatcher.matchAny(roleMapSettings.getAsArray(".users"), user.getName())) {
                sgRoles.add(roleMap);
                continue;
            }
            if (caller != null && WildcardMatcher.matchAny(roleMapSettings.getAsArray(".hosts"), caller.getAddress())) {
                sgRoles.add(roleMap);
                continue;
            }
            if (caller == null || !WildcardMatcher.matchAny(roleMapSettings.getAsArray(".hosts"), caller.getHost())) continue;
            sgRoles.add(roleMap);
        }
        return Collections.unmodifiableSet(sgRoles);
    }

    public Map<String, Boolean> mapTenants(User user, TransportAddress caller) {
        if (user == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put(user.getName(), true);
        for (String sgRole : this.mapSgRoles(user, caller)) {
            Settings tenants = this.getRolesSettings().getByPrefix(sgRole + ".tenants.");
            if (tenants == null) continue;
            for (String tenant : tenants.names()) {
                if (tenant.equals(user.getName())) continue;
                if ("RW".equalsIgnoreCase(tenants.get(tenant, "RO"))) {
                    result.put(tenant, true);
                    continue;
                }
                if (result.containsKey(tenant)) continue;
                result.put(tenant, false);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    private void handleIndicesWithWildcard(String[] action0, String permittedAliasesIndex, Map<String, Settings> permittedAliasesIndices, Set<IndexType> requestedResolvedIndexTypes, Set<IndexType> _requestedResolvedIndexTypes, Set<IndexType> _requestedResolvedIndexTypesGlobal, Set<String> requestedResolvedIndices0) {
        List<String> wi = null;
        wi = WildcardMatcher.getMatchAny(permittedAliasesIndex, requestedResolvedIndices0.toArray(new String[0]));
        if (!wi.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("  Wildcard match for {}: {}", (Object)permittedAliasesIndex, wi);
            }
            HashSet permittedTypes = new HashSet(permittedAliasesIndices.get(permittedAliasesIndex).names());
            permittedTypes.removeAll(this.DLSFLS);
            if (this.log.isDebugEnabled()) {
                this.log.debug("  matches for {}, will check now types {}", (Object)permittedAliasesIndex, permittedTypes);
            }
            for (String type : permittedTypes) {
                Set<String> resolvedActions = this.resolveActions(permittedAliasesIndices.get(permittedAliasesIndex).getAsArray(type));
                if (!WildcardMatcher.matchAll(resolvedActions.toArray(new String[0]), action0)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("    match requested action {} against {}/{}: {}", (Object)action0, (Object)permittedAliasesIndex, (Object)type, resolvedActions);
                }
                for (String it : wi) {
                    IndexType itl = new IndexType(it, type);
                    boolean removed = this.wildcardRemoveFromSet(_requestedResolvedIndexTypes, itl);
                    this.wildcardRemoveFromSet(_requestedResolvedIndexTypesGlobal, itl);
                    if (removed) {
                        this.log.debug("    removed {}", (Object)(it + type));
                        continue;
                    }
                    this.log.debug("    no match {} in {}", (Object)(it + type), _requestedResolvedIndexTypes);
                }
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("  No wildcard match found for {}", (Object)permittedAliasesIndex);
            }
            return;
        }
    }

    private void handleIndicesWithoutWildcard(String[] action0, String permittedAliasesIndex, Map<String, Settings> permittedAliasesIndices, Set<IndexType> requestedResolvedIndexTypes, Set<IndexType> _requestedResolvedIndexTypes, Set<IndexType> _requestedResolvedIndexTypesGlobal) {
        HashSet<String> resolvedPermittedAliasesIndex = new HashSet<String>();
        if (!this.resolver.hasIndexOrAlias(permittedAliasesIndex, this.clusterService.state())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("no permittedAliasesIndex '{}' found for  '{}'", (Object)permittedAliasesIndex, (Object)action0);
                for (String pai : permittedAliasesIndices.keySet()) {
                    Settings paiSettings = permittedAliasesIndices.get(pai);
                    this.log.debug("permittedAliasesIndices '{}' -> '{}'", permittedAliasesIndices, (Object)(paiSettings == null ? "null" : String.valueOf(paiSettings.getAsMap())));
                }
                this.log.debug("requestedResolvedIndexTypes '{}'", requestedResolvedIndexTypes);
            }
            resolvedPermittedAliasesIndex.add(permittedAliasesIndex);
        } else {
            resolvedPermittedAliasesIndex.addAll(Arrays.asList(this.resolver.concreteIndexNames(this.clusterService.state(), DEFAULT_INDICES_OPTIONS, new String[]{permittedAliasesIndex})));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("  resolved permitted aliases indices for {}: {}", (Object)permittedAliasesIndex, resolvedPermittedAliasesIndex);
        }
        HashSet permittedTypes = new HashSet(permittedAliasesIndices.get(permittedAliasesIndex).names());
        permittedTypes.removeAll(this.DLSFLS);
        if (this.log.isDebugEnabled()) {
            this.log.debug("  matches for {}, will check now types {}", (Object)permittedAliasesIndex, permittedTypes);
        }
        for (String type : permittedTypes) {
            Set<String> resolvedActions = this.resolveActions(permittedAliasesIndices.get(permittedAliasesIndex).getAsArray(type));
            if (!WildcardMatcher.matchAll(resolvedActions.toArray(new String[0]), action0)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("    match requested action {} against {}/{}: {}", (Object)action0, (Object)permittedAliasesIndex, (Object)type, resolvedActions);
            }
            for (String resolvedPermittedIndex : resolvedPermittedAliasesIndex) {
                IndexType itl = new IndexType(resolvedPermittedIndex, type);
                boolean removed = this.wildcardRemoveFromSet(_requestedResolvedIndexTypes, itl);
                this.wildcardRemoveFromSet(_requestedResolvedIndexTypesGlobal, itl);
                if (removed) {
                    this.log.debug("    removed {}", (Object)(resolvedPermittedIndex + type));
                    continue;
                }
                this.log.debug("    no match {} in {}", (Object)(resolvedPermittedIndex + type), _requestedResolvedIndexTypes);
            }
        }
    }

    private void handleSnapshotRestoreWritePrivileges(Set<String> actions, String permittedAliasesIndex, Map<String, Settings> permittedAliasesIndices, Set<String> requestedResolvedIndices, Set<IndexType> requestedResolvedIndices0) {
        List<String> wi = null;
        wi = WildcardMatcher.getMatchAny(permittedAliasesIndex, requestedResolvedIndices.toArray(new String[0]));
        if (!wi.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("  Wildcard match for {}: {}", (Object)permittedAliasesIndex, wi);
            }
            Set<String> resolvedActions = this.resolveActions(permittedAliasesIndices.get(permittedAliasesIndex).getAsArray("*"));
            if (this.log.isDebugEnabled()) {
                this.log.debug("  matches for {}, will check now wildcard type '*'", (Object)permittedAliasesIndex);
            }
            List<String> wa = null;
            for (String at : resolvedActions) {
                wa = WildcardMatcher.getMatchAny(at, actions.toArray(new String[0]));
                if (wa.isEmpty()) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("    match requested actions {} against {}/*: {}", actions, (Object)permittedAliasesIndex, resolvedActions);
                }
                for (String it : wi) {
                    boolean removed = this.wildcardRemoveFromSet(requestedResolvedIndices0, new IndexTypeAction(it, "*", at));
                    if (removed) {
                        this.log.debug("    removed {}", (Object)(it + '*'));
                        continue;
                    }
                    this.log.debug("    no match {} in {}", (Object)(it + '*'), requestedResolvedIndices0);
                }
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("  No wildcard match found for {}", (Object)permittedAliasesIndex);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Tuple<Set<String>, Set<String>> resolve(User user, String action, TransportRequest request, MetaData metaData) {
        if (request instanceof PutMappingRequest) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("PutMappingRequest will be handled in a special way cause they does not return indices via .indices()Instead .getConcreteIndex() must be used");
            }
            if ((concreteIndex = (pmr = (PutMappingRequest)request).getConcreteIndex()) != null && (pmr.indices() == null || pmr.indices().length == 0)) {
                return new Tuple((Object)Sets.newHashSet((Object[])new String[]{concreteIndex.getName()}), (Object)Sets.newHashSet((Object[])new String[]{pmr.type()}));
            }
        }
        if (!(request instanceof CompositeIndicesRequest) && !(request instanceof IndicesRequest)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} is not an IndicesRequest", request.getClass());
            }
            return new Tuple((Object)Sets.newHashSet((Object[])new String[]{"_all"}), (Object)Sets.newHashSet((Object[])new String[]{"_all"}));
        }
        indices = new HashSet<E>();
        types = new HashSet<E>();
        if (request instanceof CompositeIndicesRequest) {
            if (request instanceof IndicesRequest) {
                t = this.resolve(user, action, (IndicesRequest)request, metaData);
                indices.addAll((Collection)t.v1());
                types.addAll((Collection)t.v2());
            } else if (request instanceof BulkRequest) {
                for (IndicesRequest ar : ((BulkRequest)request).requests()) {
                    t = this.resolve(user, action, ar, metaData);
                    indices.addAll((Collection)t.v1());
                    types.addAll((Collection)t.v2());
                }
            } else if (request instanceof IndicesRequest) {
                t = this.resolve(user, action, (IndicesRequest)request, metaData);
                indices.addAll((Collection)t.v1());
                types.addAll((Collection)t.v2());
            } else if (request instanceof MultiGetRequest) {
                for (MultiGetRequest.Item item : ((MultiGetRequest)request).getItems()) {
                    t = this.resolve(user, action, (IndicesRequest)item, metaData);
                    indices.addAll((Collection)t.v1());
                    types.addAll((Collection)t.v2());
                }
            } else if (request instanceof MultiSearchRequest) {
                for (ActionRequest ar : ((MultiSearchRequest)request).requests()) {
                    t = this.resolve(user, action, (TransportRequest)ar, metaData);
                    indices.addAll((Collection)t.v1());
                    types.addAll((Collection)t.v2());
                }
            } else if (request instanceof MultiTermVectorsRequest) {
                for (ActionRequest ar : (Iterable<T>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/util/Iterator;, lambda$resolve$0(org.elasticsearch.transport.TransportRequest ), ()Ljava/util/Iterator;)((TransportRequest)request)) {
                    t = this.resolve(user, action, (TransportRequest)ar, metaData);
                    indices.addAll((Collection)t.v1());
                    types.addAll((Collection)t.v2());
                }
            } else if (request.getClass().getName().equals("org.elasticsearch.index.reindex.ReindexRequest")) {
                try {
                    t = this.resolve(user, action, (IndicesRequest)request.getClass().getMethod("getDestination", new Class[0]).invoke((Object)request, new Object[0]), metaData);
                    indices.addAll((Collection)t.v1());
                    types.addAll((Collection)t.v2());
                    t = this.resolve(user, action, (IndicesRequest)request.getClass().getMethod("getSearchRequest", new Class[0]).invoke((Object)request, new Object[0]), metaData);
                    indices.addAll((Collection)t.v1());
                    types.addAll((Collection)t.v2());
                }
                catch (Exception e) {
                    this.log.error("Unable to handle " + request.getClass() + " due to " + e);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(ExceptionsHelper.stackTrace((Throwable)e));
                    }
                }
            } else if (request.getClass().getName().equals("org.elasticsearch.percolator.MultiPercolateRequest")) {
                try {
                    requests = (List)request.getClass().getMethod("requests", new Class[0]).invoke((Object)request, new Object[0]);
                    for (E ar : requests) {
                        t = this.resolve(user, action, (TransportRequest)ar, metaData);
                        indices.addAll((Collection)t.v1());
                        types.addAll((Collection)t.v2());
                    }
                }
                catch (Exception e) {
                    this.log.error("Unable to handle " + request.getClass() + " due to " + e);
                    if (!this.log.isDebugEnabled()) ** GOTO lbl102
                    this.log.debug(ExceptionsHelper.stackTrace((Throwable)e));
                }
            } else {
                this.log.warn("Can not handle composite request of type '" + request.getClass().getName() + "'for " + action + " here");
            }
        } else {
            t = this.resolve(user, action, (IndicesRequest)request, metaData);
            indices = (Set)t.v1();
            types = (Set)t.v2();
        }
lbl102:
        // 13 sources

        if (this.log.isDebugEnabled()) {
            this.log.debug("pre final indices: {}", indices);
            this.log.debug("pre final types: {}", types);
        }
        if (indices == PrivilegesEvaluator.NO_INDICES_SET) {
            return new Tuple(Collections.emptySet(), Collections.unmodifiableSet(types));
        }
        if (IndexNameExpressionResolver.isAllIndices(new ArrayList<E>(indices))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("The following list are '_all' indices: {}", indices);
            }
            if (!indices.isEmpty()) {
                indices.clear();
                indices.add("_all");
            }
        }
        if (types.isEmpty()) {
            types.add("_all");
        }
        return new Tuple(Collections.unmodifiableSet(indices), Collections.unmodifiableSet(types));
    }

    private Tuple<Set<String>, Set<String>> resolve(User user, String action, IndicesRequest request, MetaData metaData) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resolve {} from {}", (Object)request.indices(), request.getClass());
        }
        Class<?> requestClass = request.getClass();
        HashSet<String> requestTypes = new HashSet<String>();
        Method typeMethod = null;
        if (this.typeCache.containsKey(requestClass)) {
            typeMethod = this.typeCache.get(requestClass);
        } else {
            try {
                typeMethod = requestClass.getMethod("type", new Class[0]);
                this.typeCache.put(requestClass, typeMethod);
            }
            catch (NoSuchMethodException e) {
                this.typeCache.put(requestClass, null);
            }
            catch (SecurityException e) {
                this.log.error("Cannot evaluate type() for {} due to {}", requestClass, (Object)e);
            }
        }
        Method typesMethod = null;
        if (this.typesCache.containsKey(requestClass)) {
            typesMethod = this.typesCache.get(requestClass);
        } else {
            try {
                typesMethod = requestClass.getMethod("types", new Class[0]);
                this.typesCache.put(requestClass, typesMethod);
            }
            catch (NoSuchMethodException e) {
                this.typesCache.put(requestClass, null);
            }
            catch (SecurityException e) {
                this.log.error("Cannot evaluate types() for {} due to {}", requestClass, (Object)e);
            }
        }
        if (typeMethod != null) {
            try {
                String type = (String)typeMethod.invoke((Object)request, new Object[0]);
                if (type != null) {
                    requestTypes.add(type);
                }
            }
            catch (Exception e) {
                this.log.error("Unable to invoke type() for {} due to {}", (Object)e, requestClass, (Object)e);
            }
        }
        if (typesMethod != null) {
            try {
                String[] types = (String[])typesMethod.invoke((Object)request, new Object[0]);
                if (types != null) {
                    requestTypes.addAll(Arrays.asList(types));
                }
            }
            catch (Exception e) {
                this.log.error("Unable to invoke types() for {} due to {}", (Object)e, requestClass, (Object)e);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("indicesOptions {}", (Object)request.indicesOptions());
            this.log.debug("{} raw indices {}", (Object)(request.indices() == null ? 0 : request.indices().length), (Object)Arrays.toString(request.indices()));
        }
        HashSet<Object> indices = new HashSet<Object>();
        if (request.indices() == null || request.indices().length == 0 || new HashSet<String>(Arrays.asList(request.indices())).equals(NULL_SET)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("No indices found in request, assume _all");
            }
            indices.addAll(Arrays.asList(this.resolver.concreteIndexNames(this.clusterService.state(), DEFAULT_INDICES_OPTIONS, new String[]{"*"})));
        } else {
            Object[] localIndices = request.indices();
            if (request instanceof FieldCapabilitiesRequest || request instanceof SearchRequest) {
                IndicesRequest.Replaceable searchRequest = (IndicesRequest.Replaceable)request;
                Map remoteClusterIndices = SearchGuardPlugin.GuiceHolder.getRemoteClusterService().groupIndices(searchRequest.indicesOptions(), searchRequest.indices(), idx -> this.resolver.hasIndexOrAlias(idx, this.clusterService.state()));
                if (remoteClusterIndices.size() > 1) {
                    OriginalIndices originalLocalIndices = (OriginalIndices)remoteClusterIndices.get("");
                    localIndices = originalLocalIndices.indices();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("remoteClusterIndices keys" + remoteClusterIndices.keySet() + "//remoteClusterIndices " + remoteClusterIndices);
                    }
                    if (localIndices.length == 0) {
                        return new Tuple(NO_INDICES_SET, requestTypes);
                    }
                }
            }
            try {
                String[] dateMathIndices = WildcardMatcher.matches("<*>", (String[])localIndices, false);
                if (dateMathIndices.length > 0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Date math indices detected {} (all: {})", (Object)dateMathIndices, (Object)localIndices);
                    }
                    for (String dateMathIndex : dateMathIndices) {
                        indices.addAll(Arrays.asList(this.resolver.resolveDateMathExpression(dateMathIndex)));
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Resolved date math indices {} to {}", (Object)dateMathIndices, indices);
                    }
                    if (localIndices.length > dateMathIndices.length) {
                        for (Object nonDateMath : localIndices) {
                            if (WildcardMatcher.match("<*>", (String)nonDateMath)) continue;
                            indices.addAll(Arrays.asList(this.resolver.concreteIndexNames(this.clusterService.state(), request.indicesOptions(), dateMathIndices)));
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Resolved additional non date math indices {} to {}", (Object)localIndices, indices);
                        }
                    }
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("No date math indices found");
                    }
                    indices.addAll(Arrays.asList(this.resolver.concreteIndexNames(this.clusterService.state(), request.indicesOptions(), (String[])localIndices)));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Resolved {} to {}", (Object)localIndices, indices);
                    }
                }
            }
            catch (Exception e) {
                this.log.debug("Cannot resolve {} (due to {}) so we use the raw values", (Object)Arrays.toString(localIndices), (Object)e);
                indices.addAll(Arrays.asList(localIndices));
            }
        }
        return new Tuple(indices, requestTypes);
    }

    private Set<String> resolveActions(String[] actions) {
        HashSet<String> resolvedActions = new HashSet<String>();
        for (int i = 0; i < actions.length; ++i) {
            String string = actions[i];
            Set<String> groups = this.ah.getGroupMembers(string);
            if (groups.isEmpty()) {
                resolvedActions.add(string);
                continue;
            }
            resolvedActions.addAll(groups);
        }
        return resolvedActions;
    }

    private boolean wildcardRemoveFromSet(Set<IndexType> set, IndexType stringContainingWc) {
        if (set.contains(stringContainingWc)) {
            return set.remove(stringContainingWc);
        }
        boolean modified = false;
        HashSet<IndexType> copy = new HashSet<IndexType>(set);
        for (IndexType it : copy) {
            if (!WildcardMatcher.match(stringContainingWc.getCombinedString(), it.getCombinedString())) continue;
            modified = set.remove(it) | modified;
        }
        return modified;
    }

    private List<String> toString(List<AliasMetaData> aliases) {
        if (aliases == null || aliases.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>(aliases.size());
        for (AliasMetaData amd : aliases) {
            if (amd == null) continue;
            ret.add(amd.alias());
        }
        return Collections.unmodifiableList(ret);
    }

    public boolean multitenancyEnabled() {
        return this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class && this.getConfigSettings().getAsBoolean("searchguard.dynamic.kibana.multitenancy_enabled", Boolean.valueOf(true)) != false;
    }

    public boolean notFailOnForbiddenEnabled() {
        return this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class && this.getConfigSettings().getAsBoolean("searchguard.dynamic.kibana.do_not_fail_on_forbidden", Boolean.valueOf(false)) != false;
    }

    public String kibanaIndex() {
        return this.getConfigSettings().get("searchguard.dynamic.kibana.index", ".kibana");
    }

    public String kibanaServerUsername() {
        return this.getConfigSettings().get("searchguard.dynamic.kibana.server_username", "kibanaserver");
    }

    public boolean kibanaIndexReadonly(User user, TransportAddress caller) {
        Set<String> sgRoles = this.mapSgRoles(user, caller);
        String kibanaIndex = this.kibanaIndex();
        for (String sgRole : sgRoles) {
            Settings sgRoleSettings = this.getRolesSettings().getByPrefix(sgRole);
            if (sgRoleSettings.names().isEmpty()) continue;
            Map permittedAliasesIndices0 = sgRoleSettings.getGroups(".indices");
            HashMap permittedAliasesIndices = new HashMap(permittedAliasesIndices0.size());
            for (String origKey : permittedAliasesIndices0.keySet()) {
                permittedAliasesIndices.put(origKey.replace("${user.name}", user.getName()).replace("${user_name}", user.getName()), permittedAliasesIndices0.get(origKey));
            }
            for (String indexPattern : permittedAliasesIndices.keySet()) {
                Settings innerSettings;
                String[] perms;
                if (!WildcardMatcher.match(indexPattern, kibanaIndex) || (perms = (innerSettings = (Settings)permittedAliasesIndices.get(indexPattern)).getAsArray("*")) == null || perms.length <= 0 || !WildcardMatcher.matchAny(this.resolveActions(perms).toArray(new String[0]), "indices:data/write/update")) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ Iterator lambda$resolve$0(TransportRequest request) {
        return ((MultiTermVectorsRequest)request).iterator();
    }

    public static class PrivEvalResponse {
        boolean allowed = false;
        Set<String> missingPrivileges = new HashSet<String>();
        Map<String, Set<String>> allowedFlsFields;
        Map<String, Set<String>> queries;

        public boolean isAllowed() {
            return this.allowed;
        }

        public Set<String> getMissingPrivileges() {
            return new HashSet<String>(this.missingPrivileges);
        }

        public Map<String, Set<String>> getAllowedFlsFields() {
            return this.allowedFlsFields;
        }

        public Map<String, Set<String>> getQueries() {
            return this.queries;
        }
    }

    private static class IndexTypeAction
    extends IndexType {
        private String action;

        public IndexTypeAction(String index, String type, String action) {
            super(index, type);
            this.action = action;
        }

        @Override
        public String getCombinedString() {
            return super.getCombinedString() + "#" + this.action;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            IndexTypeAction other = (IndexTypeAction)obj;
            return !(this.action == null ? other.action != null : !this.action.equals(other.action));
        }

        @Override
        public String toString() {
            return "IndexTypeAction [index=" + this.getIndex() + ", type=" + this.getType() + ", action=" + this.action + "]";
        }
    }

    public static class IndexType {
        private String index;
        private String type;

        public IndexType(String index, String type) {
            this.index = index;
            this.type = type.equals("_all") ? "*" : type;
        }

        public String getCombinedString() {
            return this.index + "#" + this.type;
        }

        public String getIndex() {
            return this.index;
        }

        public String getType() {
            return this.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexType other = (IndexType)obj;
            if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toString() {
            return "IndexType [index=" + this.index + ", type=" + this.type + "]";
        }
    }
}

