/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.configuration.ConfigurationLoader;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.InvalidConfigException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;

public class IndexBaseConfigurationRepository
implements ConfigurationRepository {
    private static final Logger LOGGER = LogManager.getLogger(IndexBaseConfigurationRepository.class);
    private static final Pattern DLS_PATTERN = Pattern.compile(".+\\.indices\\..+\\._dls_=.+", 32);
    private static final Pattern FLS_PATTERN = Pattern.compile(".+\\.indices\\..+\\._fls_\\.[0-9]+=.+", 32);
    private final String searchguardIndex;
    private final ConcurrentMap<String, Settings> typeToConfig;
    private final Multimap<String, ConfigurationChangeListener> configTypeToChancheListener;
    private final ConfigurationLoader cl;

    private IndexBaseConfigurationRepository(final Settings settings, final ThreadPool threadPool, final Client client, final ClusterService clusterService) {
        this.searchguardIndex = settings.get("searchguard.config_index_name", "searchguard");
        this.typeToConfig = Maps.newConcurrentMap();
        this.configTypeToChancheListener = ArrayListMultimap.create();
        this.cl = new ConfigurationLoader(client, threadPool, settings);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void afterStart() {
                final Thread bgThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LOGGER.debug("Node started, try to initialize it. Wait for at least yellow cluster state....");
                            ClusterHealthResponse response = null;
                            try {
                                response = (ClusterHealthResponse)client.admin().cluster().health(new ClusterHealthRequest(new String[]{IndexBaseConfigurationRepository.this.searchguardIndex}).waitForYellowStatus()).actionGet();
                            }
                            catch (Exception e1) {
                                LOGGER.debug("Catched a {} but we just try again ...", (Object)e1.toString());
                            }
                            while (response == null || response.isTimedOut() || response.getStatus() == ClusterHealthStatus.RED) {
                                LOGGER.warn("index '{}' not healthy yet, we try again ... (Reason: {})", (Object)IndexBaseConfigurationRepository.this.searchguardIndex, (Object)(response == null ? "no response" : (response.isTimedOut() ? "timeout" : "other, maybe red cluster")));
                                try {
                                    Thread.sleep(3000L);
                                }
                                catch (InterruptedException e1) {
                                    // empty catch block
                                }
                                try {
                                    response = (ClusterHealthResponse)client.admin().cluster().health(new ClusterHealthRequest(new String[]{IndexBaseConfigurationRepository.this.searchguardIndex}).waitForYellowStatus()).actionGet();
                                }
                                catch (Exception e1) {
                                    LOGGER.debug("Catched again a {} but we just try again ...", (Object)e1.toString());
                                }
                            }
                            Map<String, Settings> setn = null;
                            while (setn == null || !setn.keySet().containsAll(Lists.newArrayList((Object[])new String[]{"config", "roles", "rolesmapping"}))) {
                                if (setn != null) {
                                    try {
                                        Thread.sleep(3000L);
                                    }
                                    catch (InterruptedException e) {
                                        Thread.currentThread().interrupt();
                                        LOGGER.debug("Thread was interrupted so we cancle initialization");
                                        return;
                                    }
                                }
                                LOGGER.debug("Try to load config ...");
                                try {
                                    setn = IndexBaseConfigurationRepository.this.cl.load(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"}, 1L, TimeUnit.MINUTES);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    LOGGER.debug("Thread was interrupted so we cancle initialization");
                                    return;
                                }
                                catch (TimeoutException e) {
                                    LOGGER.warn("Timeout, we just try again in a few seconds ... ");
                                }
                            }
                            LOGGER.debug("Retrieved {} configs", setn.keySet());
                            IndexBaseConfigurationRepository.this.reloadConfiguration(Arrays.asList("config", "roles", "rolesmapping", "internalusers", "actiongroups"));
                            LOGGER.info("Node '{}' initialized", (Object)clusterService.localNode().getName());
                        }
                        catch (Exception e) {
                            LOGGER.error("Unexpected exception while initializing node " + e, (Throwable)e);
                        }
                    }
                });
                LOGGER.info("Check if " + IndexBaseConfigurationRepository.this.searchguardIndex + " index exists ...");
                try {
                    IndicesExistsRequest ier = (IndicesExistsRequest)new IndicesExistsRequest(new String[]{IndexBaseConfigurationRepository.this.searchguardIndex}).masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
                    ThreadContext threadContext = threadPool.getThreadContext();
                    try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
                        threadContext.putHeader("_sg_conf_request", "true");
                        client.admin().indices().exists(ier, (ActionListener)new ActionListener<IndicesExistsResponse>(){

                            public void onResponse(IndicesExistsResponse response) {
                                if (response != null && response.isExists()) {
                                    bgThread.start();
                                } else if (settings.getAsBoolean("action.master.force_local", Boolean.valueOf(false)).booleanValue() && settings.getByPrefix("tribe").getAsMap().size() > 0) {
                                    LOGGER.info("{} index does not exist yet, but we are a tribe node. So we will load the config anyhow until we got it ...", (Object)IndexBaseConfigurationRepository.this.searchguardIndex);
                                    bgThread.start();
                                } else {
                                    LOGGER.info("{} index does not exist yet, so no need to load config on node startup. Use sgadmin to initialize cluster", (Object)IndexBaseConfigurationRepository.this.searchguardIndex);
                                }
                            }

                            public void onFailure(Exception e) {
                                LOGGER.error("Failure while checking {} index {}", (Object)e, (Object)IndexBaseConfigurationRepository.this.searchguardIndex, (Object)e);
                                bgThread.start();
                            }
                        });
                    }
                }
                catch (Throwable e2) {
                    LOGGER.error("Failure while executing IndicesExistsRequest {}", (Object)e2, (Object)e2);
                    bgThread.start();
                }
            }
        });
    }

    public static ConfigurationRepository create(Settings settings, ThreadPool threadPool, Client client, ClusterService clusterService) {
        IndexBaseConfigurationRepository repository = new IndexBaseConfigurationRepository(settings, threadPool, client, clusterService);
        return repository;
    }

    @Override
    public Settings getConfiguration(String configurationType) {
        Settings result = (Settings)this.typeToConfig.get(configurationType);
        if (result != null) {
            return result;
        }
        Map<String, Settings> loaded = this.loadConfigurations(Collections.singleton(configurationType));
        result = loaded.get(configurationType);
        return this.putSettingsToCache(configurationType, result);
    }

    private Settings putSettingsToCache(String configurationType, Settings result) {
        if (result != null) {
            this.typeToConfig.putIfAbsent(configurationType, result);
        }
        return (Settings)this.typeToConfig.get(configurationType);
    }

    @Override
    public Map<String, Settings> getConfiguration(Collection<String> configTypes) {
        ArrayList typesToLoad = Lists.newArrayList();
        HashMap result = Maps.newHashMap();
        for (String type : configTypes) {
            Settings conf = (Settings)this.typeToConfig.get(type);
            if (conf != null) {
                result.put(type, conf);
                continue;
            }
            typesToLoad.add(type);
        }
        if (typesToLoad.isEmpty()) {
            return result;
        }
        Map<String, Settings> loaded = this.loadConfigurations(typesToLoad);
        for (Map.Entry<String, Settings> entry : loaded.entrySet()) {
            Settings conf = this.putSettingsToCache(entry.getKey(), entry.getValue());
            if (conf == null) continue;
            result.put(entry.getKey(), conf);
        }
        return result;
    }

    @Override
    public Map<String, Settings> reloadConfiguration(Collection<String> configTypes) {
        Map<String, Settings> loaded = this.loadConfigurations(configTypes);
        this.typeToConfig.clear();
        this.typeToConfig.putAll(loaded);
        this.notifyAboutChanges(loaded);
        return loaded;
    }

    @Override
    public void persistConfiguration(String configurationType, Settings settings) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public synchronized void subscribeOnChange(String configurationType, ConfigurationChangeListener listener) {
        LOGGER.debug("Subscribe on configuration changes by type {} with listener {}", (Object)configurationType, (Object)listener);
        this.configTypeToChancheListener.put((Object)configurationType, (Object)listener);
    }

    private synchronized void notifyAboutChanges(Map<String, Settings> typeToConfig) {
        for (Map.Entry entry : this.configTypeToChancheListener.entries()) {
            String type = (String)entry.getKey();
            ConfigurationChangeListener listener = (ConfigurationChangeListener)entry.getValue();
            Settings settings = typeToConfig.get(type);
            if (settings == null) continue;
            LOGGER.debug("Notify {} listener about change configuration with type {}", (Object)listener, (Object)type);
            listener.onChange(settings);
        }
    }

    private Map<String, Settings> loadConfigurations(Collection<String> configTypes) {
        try {
            return this.validate(this.cl.load(configTypes.toArray(new String[0]), 1L, TimeUnit.MINUTES));
        }
        catch (Exception e) {
            LOGGER.error("Unable to load configuration because of " + e, (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private Map<String, Settings> validate(Map<String, Settings> conf) throws InvalidConfigException {
        String rolesDelimited;
        Settings roles = conf.get("roles");
        if (roles != null && (rolesDelimited = roles.toDelimitedString('#')) != null) {
            String[] rolesString;
            for (String role : rolesString = rolesDelimited.split("#")) {
                if (role.contains("_fls_.") && !FLS_PATTERN.matcher(role).matches()) {
                    LOGGER.error("Invalid FLS configuration detected, FLS/DLS will not work correctly: {}", (Object)role);
                }
                if (!role.contains("_dls_=") || DLS_PATTERN.matcher(role).matches()) continue;
                LOGGER.error("Invalid DLS configuration detected, FLS/DLS will not work correctly: {}", (Object)role);
            }
        }
        return conf;
    }
}

